package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAllTenantBindNumberBinding invokes the outboundbot.ListAllTenantBindNumberBinding API synchronously
func (client *Client) ListAllTenantBindNumberBinding(request *ListAllTenantBindNumberBindingRequest) (response *ListAllTenantBindNumberBindingResponse, err error) {
	response = CreateListAllTenantBindNumberBindingResponse()
	err = client.DoAction(request, response)
	return
}

// ListAllTenantBindNumberBindingWithChan invokes the outboundbot.ListAllTenantBindNumberBinding API asynchronously
func (client *Client) ListAllTenantBindNumberBindingWithChan(request *ListAllTenantBindNumberBindingRequest) (<-chan *ListAllTenantBindNumberBindingResponse, <-chan error) {
	responseChan := make(chan *ListAllTenantBindNumberBindingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAllTenantBindNumberBinding(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAllTenantBindNumberBindingWithCallback invokes the outboundbot.ListAllTenantBindNumberBinding API asynchronously
func (client *Client) ListAllTenantBindNumberBindingWithCallback(request *ListAllTenantBindNumberBindingRequest, callback func(response *ListAllTenantBindNumberBindingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAllTenantBindNumberBindingResponse
		var err error
		defer close(result)
		response, err = client.ListAllTenantBindNumberBinding(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAllTenantBindNumberBindingRequest is the request struct for api ListAllTenantBindNumberBinding
type ListAllTenantBindNumberBindingRequest struct {
	*requests.RpcRequest
	Tenant string `position:"Query" name:"Tenant"`
}

// ListAllTenantBindNumberBindingResponse is the response struct for api ListAllTenantBindNumberBinding
type ListAllTenantBindNumberBindingResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateListAllTenantBindNumberBindingRequest creates a request to invoke ListAllTenantBindNumberBinding API
func CreateListAllTenantBindNumberBindingRequest() (request *ListAllTenantBindNumberBindingRequest) {
	request = &ListAllTenantBindNumberBindingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "ListAllTenantBindNumberBinding", "", "")
	request.Method = requests.POST
	return
}

// CreateListAllTenantBindNumberBindingResponse creates a response to parse from ListAllTenantBindNumberBinding response
func CreateListAllTenantBindNumberBindingResponse() (response *ListAllTenantBindNumberBindingResponse) {
	response = &ListAllTenantBindNumberBindingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
