package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDatasource invokes the paifeaturestore.UpdateDatasource API synchronously
func (client *Client) UpdateDatasource(request *UpdateDatasourceRequest) (response *UpdateDatasourceResponse, err error) {
	response = CreateUpdateDatasourceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDatasourceWithChan invokes the paifeaturestore.UpdateDatasource API asynchronously
func (client *Client) UpdateDatasourceWithChan(request *UpdateDatasourceRequest) (<-chan *UpdateDatasourceResponse, <-chan error) {
	responseChan := make(chan *UpdateDatasourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDatasource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDatasourceWithCallback invokes the paifeaturestore.UpdateDatasource API asynchronously
func (client *Client) UpdateDatasourceWithCallback(request *UpdateDatasourceRequest, callback func(response *UpdateDatasourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDatasourceResponse
		var err error
		defer close(result)
		response, err = client.UpdateDatasource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDatasourceRequest is the request struct for api UpdateDatasource
type UpdateDatasourceRequest struct {
	*requests.RoaRequest
	Body         string `position:"Body" name:"body"`
	InstanceId   string `position:"Path" name:"InstanceId"`
	DatasourceId string `position:"Path" name:"DatasourceId"`
}

// UpdateDatasourceResponse is the response struct for api UpdateDatasource
type UpdateDatasourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDatasourceRequest creates a request to invoke UpdateDatasource API
func CreateUpdateDatasourceRequest() (request *UpdateDatasourceRequest) {
	request = &UpdateDatasourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "UpdateDatasource", "/api/v1/instances/[InstanceId]/datasources/[DatasourceId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateDatasourceResponse creates a response to parse from UpdateDatasource response
func CreateUpdateDatasourceResponse() (response *UpdateDatasourceResponse) {
	response = &UpdateDatasourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
