package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartTrafficControlTask invokes the pairecservice.StartTrafficControlTask API synchronously
func (client *Client) StartTrafficControlTask(request *StartTrafficControlTaskRequest) (response *StartTrafficControlTaskResponse, err error) {
	response = CreateStartTrafficControlTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StartTrafficControlTaskWithChan invokes the pairecservice.StartTrafficControlTask API asynchronously
func (client *Client) StartTrafficControlTaskWithChan(request *StartTrafficControlTaskRequest) (<-chan *StartTrafficControlTaskResponse, <-chan error) {
	responseChan := make(chan *StartTrafficControlTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartTrafficControlTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartTrafficControlTaskWithCallback invokes the pairecservice.StartTrafficControlTask API asynchronously
func (client *Client) StartTrafficControlTaskWithCallback(request *StartTrafficControlTaskRequest, callback func(response *StartTrafficControlTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartTrafficControlTaskResponse
		var err error
		defer close(result)
		response, err = client.StartTrafficControlTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartTrafficControlTaskRequest is the request struct for api StartTrafficControlTask
type StartTrafficControlTaskRequest struct {
	*requests.RoaRequest
	TrafficControlTaskId string `position:"Path" name:"TrafficControlTaskId"`
	Body                 string `position:"Body" name:"body"`
}

// StartTrafficControlTaskResponse is the response struct for api StartTrafficControlTask
type StartTrafficControlTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartTrafficControlTaskRequest creates a request to invoke StartTrafficControlTask API
func CreateStartTrafficControlTaskRequest() (request *StartTrafficControlTaskRequest) {
	request = &StartTrafficControlTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "StartTrafficControlTask", "/api/v1/trafficcontroltasks/[TrafficControlTaskId]/action/start", "", "")
	request.Method = requests.POST
	return
}

// CreateStartTrafficControlTaskResponse creates a response to parse from StartTrafficControlTask response
func CreateStartTrafficControlTaskResponse() (response *StartTrafficControlTaskResponse) {
	response = &StartTrafficControlTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
