package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateParam invokes the pairecservice.UpdateParam API synchronously
func (client *Client) UpdateParam(request *UpdateParamRequest) (response *UpdateParamResponse, err error) {
	response = CreateUpdateParamResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateParamWithChan invokes the pairecservice.UpdateParam API asynchronously
func (client *Client) UpdateParamWithChan(request *UpdateParamRequest) (<-chan *UpdateParamResponse, <-chan error) {
	responseChan := make(chan *UpdateParamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateParam(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateParamWithCallback invokes the pairecservice.UpdateParam API asynchronously
func (client *Client) UpdateParamWithCallback(request *UpdateParamRequest, callback func(response *UpdateParamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateParamResponse
		var err error
		defer close(result)
		response, err = client.UpdateParam(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateParamRequest is the request struct for api UpdateParam
type UpdateParamRequest struct {
	*requests.RoaRequest
	ParamId string `position:"Path" name:"ParamId"`
	Body    string `position:"Body" name:"body"`
}

// UpdateParamResponse is the response struct for api UpdateParam
type UpdateParamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateParamRequest creates a request to invoke UpdateParam API
func CreateUpdateParamRequest() (request *UpdateParamRequest) {
	request = &UpdateParamRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "UpdateParam", "/api/v1/params/[ParamId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateParamResponse creates a response to parse from UpdateParam response
func CreateUpdateParamResponse() (response *UpdateParamResponse) {
	response = &UpdateParamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
