package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTrafficControlTask invokes the pairecservice.UpdateTrafficControlTask API synchronously
func (client *Client) UpdateTrafficControlTask(request *UpdateTrafficControlTaskRequest) (response *UpdateTrafficControlTaskResponse, err error) {
	response = CreateUpdateTrafficControlTaskResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTrafficControlTaskWithChan invokes the pairecservice.UpdateTrafficControlTask API asynchronously
func (client *Client) UpdateTrafficControlTaskWithChan(request *UpdateTrafficControlTaskRequest) (<-chan *UpdateTrafficControlTaskResponse, <-chan error) {
	responseChan := make(chan *UpdateTrafficControlTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTrafficControlTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTrafficControlTaskWithCallback invokes the pairecservice.UpdateTrafficControlTask API asynchronously
func (client *Client) UpdateTrafficControlTaskWithCallback(request *UpdateTrafficControlTaskRequest, callback func(response *UpdateTrafficControlTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTrafficControlTaskResponse
		var err error
		defer close(result)
		response, err = client.UpdateTrafficControlTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTrafficControlTaskRequest is the request struct for api UpdateTrafficControlTask
type UpdateTrafficControlTaskRequest struct {
	*requests.RoaRequest
	TrafficControlTaskId string `position:"Path" name:"TrafficControlTaskId"`
	Body                 string `position:"Body" name:"body"`
}

// UpdateTrafficControlTaskResponse is the response struct for api UpdateTrafficControlTask
type UpdateTrafficControlTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTrafficControlTaskRequest creates a request to invoke UpdateTrafficControlTask API
func CreateUpdateTrafficControlTaskRequest() (request *UpdateTrafficControlTaskRequest) {
	request = &UpdateTrafficControlTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "UpdateTrafficControlTask", "/api/v1/trafficcontroltasks/[TrafficControlTaskId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateTrafficControlTaskResponse creates a response to parse from UpdateTrafficControlTask response
func CreateUpdateTrafficControlTaskResponse() (response *UpdateTrafficControlTaskResponse) {
	response = &UpdateTrafficControlTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
