package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBClusterStoragePerformance invokes the polardb.ModifyDBClusterStoragePerformance API synchronously
func (client *Client) ModifyDBClusterStoragePerformance(request *ModifyDBClusterStoragePerformanceRequest) (response *ModifyDBClusterStoragePerformanceResponse, err error) {
	response = CreateModifyDBClusterStoragePerformanceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBClusterStoragePerformanceWithChan invokes the polardb.ModifyDBClusterStoragePerformance API asynchronously
func (client *Client) ModifyDBClusterStoragePerformanceWithChan(request *ModifyDBClusterStoragePerformanceRequest) (<-chan *ModifyDBClusterStoragePerformanceResponse, <-chan error) {
	responseChan := make(chan *ModifyDBClusterStoragePerformanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBClusterStoragePerformance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBClusterStoragePerformanceWithCallback invokes the polardb.ModifyDBClusterStoragePerformance API asynchronously
func (client *Client) ModifyDBClusterStoragePerformanceWithCallback(request *ModifyDBClusterStoragePerformanceRequest, callback func(response *ModifyDBClusterStoragePerformanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBClusterStoragePerformanceResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBClusterStoragePerformance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBClusterStoragePerformanceRequest is the request struct for api ModifyDBClusterStoragePerformance
type ModifyDBClusterStoragePerformanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken     string           `position:"Query" name:"ClientToken"`
	StorageType     string           `position:"Query" name:"StorageType"`
	DBClusterId     string           `position:"Query" name:"DBClusterId"`
	BurstingEnabled string           `position:"Query" name:"BurstingEnabled"`
	ProvisionedIops requests.Integer `position:"Query" name:"ProvisionedIops"`
	ModifyType      string           `position:"Query" name:"ModifyType"`
}

// ModifyDBClusterStoragePerformanceResponse is the response struct for api ModifyDBClusterStoragePerformance
type ModifyDBClusterStoragePerformanceResponse struct {
	*responses.BaseResponse
	DBClusterId string `json:"DBClusterId" xml:"DBClusterId"`
	OrderId     string `json:"OrderId" xml:"OrderId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBClusterStoragePerformanceRequest creates a request to invoke ModifyDBClusterStoragePerformance API
func CreateModifyDBClusterStoragePerformanceRequest() (request *ModifyDBClusterStoragePerformanceRequest) {
	request = &ModifyDBClusterStoragePerformanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "ModifyDBClusterStoragePerformance", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBClusterStoragePerformanceResponse creates a response to parse from ModifyDBClusterStoragePerformance response
func CreateModifyDBClusterStoragePerformanceResponse() (response *ModifyDBClusterStoragePerformanceResponse) {
	response = &ModifyDBClusterStoragePerformanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
