package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEnvs invokes the pts.ListEnvs API synchronously
func (client *Client) ListEnvs(request *ListEnvsRequest) (response *ListEnvsResponse, err error) {
	response = CreateListEnvsResponse()
	err = client.DoAction(request, response)
	return
}

// ListEnvsWithChan invokes the pts.ListEnvs API asynchronously
func (client *Client) ListEnvsWithChan(request *ListEnvsRequest) (<-chan *ListEnvsResponse, <-chan error) {
	responseChan := make(chan *ListEnvsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEnvs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEnvsWithCallback invokes the pts.ListEnvs API asynchronously
func (client *Client) ListEnvsWithCallback(request *ListEnvsRequest, callback func(response *ListEnvsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEnvsResponse
		var err error
		defer close(result)
		response, err = client.ListEnvs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEnvsRequest is the request struct for api ListEnvs
type ListEnvsRequest struct {
	*requests.RpcRequest
	EnvName    string           `position:"Query" name:"EnvName"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	EnvId      string           `position:"Query" name:"EnvId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListEnvsResponse is the response struct for api ListEnvs
type ListEnvsResponse struct {
	*responses.BaseResponse
	TotalCount     int64  `json:"TotalCount" xml:"TotalCount"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Message        string `json:"Message" xml:"Message"`
	PageSize       int    `json:"PageSize" xml:"PageSize"`
	PageNumber     int    `json:"PageNumber" xml:"PageNumber"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Envs           []Env  `json:"Envs" xml:"Envs"`
}

// CreateListEnvsRequest creates a request to invoke ListEnvs API
func CreateListEnvsRequest() (request *ListEnvsRequest) {
	request = &ListEnvsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "ListEnvs", "", "")
	request.Method = requests.POST
	return
}

// CreateListEnvsResponse creates a response to parse from ListEnvs response
func CreateListEnvsResponse() (response *ListEnvsResponse) {
	response = &ListEnvsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
