package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPtsScene invokes the pts.ModifyPtsScene API synchronously
func (client *Client) ModifyPtsScene(request *ModifyPtsSceneRequest) (response *ModifyPtsSceneResponse, err error) {
	response = CreateModifyPtsSceneResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPtsSceneWithChan invokes the pts.ModifyPtsScene API asynchronously
func (client *Client) ModifyPtsSceneWithChan(request *ModifyPtsSceneRequest) (<-chan *ModifyPtsSceneResponse, <-chan error) {
	responseChan := make(chan *ModifyPtsSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPtsScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPtsSceneWithCallback invokes the pts.ModifyPtsScene API asynchronously
func (client *Client) ModifyPtsSceneWithCallback(request *ModifyPtsSceneRequest, callback func(response *ModifyPtsSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPtsSceneResponse
		var err error
		defer close(result)
		response, err = client.ModifyPtsScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPtsSceneRequest is the request struct for api ModifyPtsScene
type ModifyPtsSceneRequest struct {
	*requests.RpcRequest
	Scene string `position:"Body" name:"Scene"`
}

// ModifyPtsSceneResponse is the response struct for api ModifyPtsScene
type ModifyPtsSceneResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateModifyPtsSceneRequest creates a request to invoke ModifyPtsScene API
func CreateModifyPtsSceneRequest() (request *ModifyPtsSceneRequest) {
	request = &ModifyPtsSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "ModifyPtsScene", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyPtsSceneResponse creates a response to parse from ModifyPtsScene response
func CreateModifyPtsSceneResponse() (response *ModifyPtsSceneResponse) {
	response = &ModifyPtsSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
