package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartDebugPtsScene invokes the pts.StartDebugPtsScene API synchronously
func (client *Client) StartDebugPtsScene(request *StartDebugPtsSceneRequest) (response *StartDebugPtsSceneResponse, err error) {
	response = CreateStartDebugPtsSceneResponse()
	err = client.DoAction(request, response)
	return
}

// StartDebugPtsSceneWithChan invokes the pts.StartDebugPtsScene API asynchronously
func (client *Client) StartDebugPtsSceneWithChan(request *StartDebugPtsSceneRequest) (<-chan *StartDebugPtsSceneResponse, <-chan error) {
	responseChan := make(chan *StartDebugPtsSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartDebugPtsScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartDebugPtsSceneWithCallback invokes the pts.StartDebugPtsScene API asynchronously
func (client *Client) StartDebugPtsSceneWithCallback(request *StartDebugPtsSceneRequest, callback func(response *StartDebugPtsSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartDebugPtsSceneResponse
		var err error
		defer close(result)
		response, err = client.StartDebugPtsScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartDebugPtsSceneRequest is the request struct for api StartDebugPtsScene
type StartDebugPtsSceneRequest struct {
	*requests.RpcRequest
	SceneId string `position:"Query" name:"SceneId"`
}

// StartDebugPtsSceneResponse is the response struct for api StartDebugPtsScene
type StartDebugPtsSceneResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Message        string `json:"Message" xml:"Message"`
	PlanId         string `json:"PlanId" xml:"PlanId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateStartDebugPtsSceneRequest creates a request to invoke StartDebugPtsScene API
func CreateStartDebugPtsSceneRequest() (request *StartDebugPtsSceneRequest) {
	request = &StartDebugPtsSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "StartDebugPtsScene", "", "")
	request.Method = requests.POST
	return
}

// CreateStartDebugPtsSceneResponse creates a response to parse from StartDebugPtsScene response
func CreateStartDebugPtsSceneResponse() (response *StartDebugPtsSceneResponse) {
	response = &StartDebugPtsSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
