package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePtsSceneBaseLine invokes the pts.UpdatePtsSceneBaseLine API synchronously
func (client *Client) UpdatePtsSceneBaseLine(request *UpdatePtsSceneBaseLineRequest) (response *UpdatePtsSceneBaseLineResponse, err error) {
	response = CreateUpdatePtsSceneBaseLineResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePtsSceneBaseLineWithChan invokes the pts.UpdatePtsSceneBaseLine API asynchronously
func (client *Client) UpdatePtsSceneBaseLineWithChan(request *UpdatePtsSceneBaseLineRequest) (<-chan *UpdatePtsSceneBaseLineResponse, <-chan error) {
	responseChan := make(chan *UpdatePtsSceneBaseLineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePtsSceneBaseLine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePtsSceneBaseLineWithCallback invokes the pts.UpdatePtsSceneBaseLine API asynchronously
func (client *Client) UpdatePtsSceneBaseLineWithCallback(request *UpdatePtsSceneBaseLineRequest, callback func(response *UpdatePtsSceneBaseLineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePtsSceneBaseLineResponse
		var err error
		defer close(result)
		response, err = client.UpdatePtsSceneBaseLine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePtsSceneBaseLineRequest is the request struct for api UpdatePtsSceneBaseLine
type UpdatePtsSceneBaseLineRequest struct {
	*requests.RpcRequest
	SceneBaseline string `position:"Query" name:"SceneBaseline"`
	SceneId       string `position:"Query" name:"SceneId"`
	ApiBaselines  string `position:"Query" name:"ApiBaselines"`
}

// UpdatePtsSceneBaseLineResponse is the response struct for api UpdatePtsSceneBaseLine
type UpdatePtsSceneBaseLineResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdatePtsSceneBaseLineRequest creates a request to invoke UpdatePtsSceneBaseLine API
func CreateUpdatePtsSceneBaseLineRequest() (request *UpdatePtsSceneBaseLineRequest) {
	request = &UpdatePtsSceneBaseLineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "UpdatePtsSceneBaseLine", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdatePtsSceneBaseLineResponse creates a response to parse from UpdatePtsSceneBaseLine response
func CreateUpdatePtsSceneBaseLineResponse() (response *UpdatePtsSceneBaseLineResponse) {
	response = &UpdatePtsSceneBaseLineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
