package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SmartqAuthorize invokes the quickbi_public.SmartqAuthorize API synchronously
func (client *Client) SmartqAuthorize(request *SmartqAuthorizeRequest) (response *SmartqAuthorizeResponse, err error) {
	response = CreateSmartqAuthorizeResponse()
	err = client.DoAction(request, response)
	return
}

// SmartqAuthorizeWithChan invokes the quickbi_public.SmartqAuthorize API asynchronously
func (client *Client) SmartqAuthorizeWithChan(request *SmartqAuthorizeRequest) (<-chan *SmartqAuthorizeResponse, <-chan error) {
	responseChan := make(chan *SmartqAuthorizeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SmartqAuthorize(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SmartqAuthorizeWithCallback invokes the quickbi_public.SmartqAuthorize API asynchronously
func (client *Client) SmartqAuthorizeWithCallback(request *SmartqAuthorizeRequest, callback func(response *SmartqAuthorizeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SmartqAuthorizeResponse
		var err error
		defer close(result)
		response, err = client.SmartqAuthorize(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SmartqAuthorizeRequest is the request struct for api SmartqAuthorize
type SmartqAuthorizeRequest struct {
	*requests.RpcRequest
	LlmCubeThemes string           `position:"Query" name:"LlmCubeThemes"`
	AccessPoint   string           `position:"Query" name:"AccessPoint"`
	LlmCubes      string           `position:"Query" name:"LlmCubes"`
	SignType      string           `position:"Query" name:"SignType"`
	OperationType requests.Integer `position:"Query" name:"OperationType"`
	ExpireDay     string           `position:"Query" name:"ExpireDay"`
	UserIds       string           `position:"Query" name:"UserIds"`
}

// SmartqAuthorizeResponse is the response struct for api SmartqAuthorize
type SmartqAuthorizeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    []Data `json:"Result" xml:"Result"`
}

// CreateSmartqAuthorizeRequest creates a request to invoke SmartqAuthorize API
func CreateSmartqAuthorizeRequest() (request *SmartqAuthorizeRequest) {
	request = &SmartqAuthorizeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "SmartqAuthorize", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSmartqAuthorizeResponse creates a response to parse from SmartqAuthorize response
func CreateSmartqAuthorizeResponse() (response *SmartqAuthorizeResponse) {
	response = &SmartqAuthorizeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
