package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListQuotaApplicationTemplates invokes the quotas.ListQuotaApplicationTemplates API synchronously
func (client *Client) ListQuotaApplicationTemplates(request *ListQuotaApplicationTemplatesRequest) (response *ListQuotaApplicationTemplatesResponse, err error) {
	response = CreateListQuotaApplicationTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListQuotaApplicationTemplatesWithChan invokes the quotas.ListQuotaApplicationTemplates API asynchronously
func (client *Client) ListQuotaApplicationTemplatesWithChan(request *ListQuotaApplicationTemplatesRequest) (<-chan *ListQuotaApplicationTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListQuotaApplicationTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListQuotaApplicationTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListQuotaApplicationTemplatesWithCallback invokes the quotas.ListQuotaApplicationTemplates API asynchronously
func (client *Client) ListQuotaApplicationTemplatesWithCallback(request *ListQuotaApplicationTemplatesRequest, callback func(response *ListQuotaApplicationTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListQuotaApplicationTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListQuotaApplicationTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListQuotaApplicationTemplatesRequest is the request struct for api ListQuotaApplicationTemplates
type ListQuotaApplicationTemplatesRequest struct {
	*requests.RpcRequest
	ProductCode     string                                     `position:"Body" name:"ProductCode"`
	QuotaActionCode string                                     `position:"Body" name:"QuotaActionCode"`
	NextToken       string                                     `position:"Query" name:"NextToken"`
	Id              string                                     `position:"Body" name:"Id"`
	QuotaCategory   string                                     `position:"Body" name:"QuotaCategory"`
	OriginalContext string                                     `position:"Body" name:"OriginalContext"`
	MaxResults      requests.Integer                           `position:"Body" name:"MaxResults"`
	Dimensions      *[]ListQuotaApplicationTemplatesDimensions `position:"Body" name:"Dimensions"  type:"Repeated"`
}

// ListQuotaApplicationTemplatesDimensions is a repeated param struct in ListQuotaApplicationTemplatesRequest
type ListQuotaApplicationTemplatesDimensions struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListQuotaApplicationTemplatesResponse is the response struct for api ListQuotaApplicationTemplates
type ListQuotaApplicationTemplatesResponse struct {
	*responses.BaseResponse
	RequestId                 string                          `json:"RequestId" xml:"RequestId"`
	MaxResults                int                             `json:"MaxResults" xml:"MaxResults"`
	NextToken                 string                          `json:"NextToken" xml:"NextToken"`
	TotalCount                int                             `json:"TotalCount" xml:"TotalCount"`
	QuotaApplicationTemplates []QuotaApplicationTemplatesItem `json:"QuotaApplicationTemplates" xml:"QuotaApplicationTemplates"`
}

// CreateListQuotaApplicationTemplatesRequest creates a request to invoke ListQuotaApplicationTemplates API
func CreateListQuotaApplicationTemplatesRequest() (request *ListQuotaApplicationTemplatesRequest) {
	request = &ListQuotaApplicationTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "ListQuotaApplicationTemplates", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListQuotaApplicationTemplatesResponse creates a response to parse from ListQuotaApplicationTemplates response
func CreateListQuotaApplicationTemplatesResponse() (response *ListQuotaApplicationTemplatesResponse) {
	response = &ListQuotaApplicationTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
