package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceSecurityGroupRule invokes the rds.DescribeDBInstanceSecurityGroupRule API synchronously
func (client *Client) DescribeDBInstanceSecurityGroupRule(request *DescribeDBInstanceSecurityGroupRuleRequest) (response *DescribeDBInstanceSecurityGroupRuleResponse, err error) {
	response = CreateDescribeDBInstanceSecurityGroupRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceSecurityGroupRuleWithChan invokes the rds.DescribeDBInstanceSecurityGroupRule API asynchronously
func (client *Client) DescribeDBInstanceSecurityGroupRuleWithChan(request *DescribeDBInstanceSecurityGroupRuleRequest) (<-chan *DescribeDBInstanceSecurityGroupRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceSecurityGroupRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceSecurityGroupRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceSecurityGroupRuleWithCallback invokes the rds.DescribeDBInstanceSecurityGroupRule API asynchronously
func (client *Client) DescribeDBInstanceSecurityGroupRuleWithCallback(request *DescribeDBInstanceSecurityGroupRuleRequest, callback func(response *DescribeDBInstanceSecurityGroupRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceSecurityGroupRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceSecurityGroupRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceSecurityGroupRuleRequest is the request struct for api DescribeDBInstanceSecurityGroupRule
type DescribeDBInstanceSecurityGroupRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
}

// DescribeDBInstanceSecurityGroupRuleResponse is the response struct for api DescribeDBInstanceSecurityGroupRule
type DescribeDBInstanceSecurityGroupRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDescribeDBInstanceSecurityGroupRuleRequest creates a request to invoke DescribeDBInstanceSecurityGroupRule API
func CreateDescribeDBInstanceSecurityGroupRuleRequest() (request *DescribeDBInstanceSecurityGroupRuleRequest) {
	request = &DescribeDBInstanceSecurityGroupRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeDBInstanceSecurityGroupRule", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceSecurityGroupRuleResponse creates a response to parse from DescribeDBInstanceSecurityGroupRule response
func CreateDescribeDBInstanceSecurityGroupRuleResponse() (response *DescribeDBInstanceSecurityGroupRuleResponse) {
	response = &DescribeDBInstanceSecurityGroupRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
