package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserBackupFiles invokes the rds.ListUserBackupFiles API synchronously
func (client *Client) ListUserBackupFiles(request *ListUserBackupFilesRequest) (response *ListUserBackupFilesResponse, err error) {
	response = CreateListUserBackupFilesResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserBackupFilesWithChan invokes the rds.ListUserBackupFiles API asynchronously
func (client *Client) ListUserBackupFilesWithChan(request *ListUserBackupFilesRequest) (<-chan *ListUserBackupFilesResponse, <-chan error) {
	responseChan := make(chan *ListUserBackupFilesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserBackupFiles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserBackupFilesWithCallback invokes the rds.ListUserBackupFiles API asynchronously
func (client *Client) ListUserBackupFilesWithCallback(request *ListUserBackupFilesRequest, callback func(response *ListUserBackupFilesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserBackupFilesResponse
		var err error
		defer close(result)
		response, err = client.ListUserBackupFiles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserBackupFilesRequest is the request struct for api ListUserBackupFiles
type ListUserBackupFilesRequest struct {
	*requests.RpcRequest
	Tag4Value            string           `position:"Query" name:"Tag.4.value"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Tag2Key              string           `position:"Query" name:"Tag.2.key"`
	Tag3Key              string           `position:"Query" name:"Tag.3.key"`
	Tag1Value            string           `position:"Query" name:"Tag.1.value"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	Engine               string           `position:"Query" name:"Engine"`
	Tag3Value            string           `position:"Query" name:"Tag.3.value"`
	Tag5Key              string           `position:"Query" name:"Tag.5.key"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	BackupId             string           `position:"Query" name:"BackupId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Tag5Value            string           `position:"Query" name:"Tag.5.value"`
	Tags                 string           `position:"Query" name:"Tags"`
	Tag1Key              string           `position:"Query" name:"Tag.1.key"`
	OpsServiceVersion    string           `position:"Query" name:"OpsServiceVersion"`
	OssUrl               string           `position:"Query" name:"OssUrl"`
	Tag2Value            string           `position:"Query" name:"Tag.2.value"`
	Tag4Key              string           `position:"Query" name:"Tag.4.key"`
	Comment              string           `position:"Query" name:"Comment"`
	Status               string           `position:"Query" name:"Status"`
}

// ListUserBackupFilesResponse is the response struct for api ListUserBackupFiles
type ListUserBackupFilesResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Records   []RecordsItem `json:"Records" xml:"Records"`
}

// CreateListUserBackupFilesRequest creates a request to invoke ListUserBackupFiles API
func CreateListUserBackupFilesRequest() (request *ListUserBackupFilesRequest) {
	request = &ListUserBackupFilesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ListUserBackupFiles", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListUserBackupFilesResponse creates a response to parse from ListUserBackupFiles response
func CreateListUserBackupFilesResponse() (response *ListUserBackupFilesResponse) {
	response = &ListUserBackupFilesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
