package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteMultiAccountSQLQuery invokes the resourcecenter.ExecuteMultiAccountSQLQuery API synchronously
func (client *Client) ExecuteMultiAccountSQLQuery(request *ExecuteMultiAccountSQLQueryRequest) (response *ExecuteMultiAccountSQLQueryResponse, err error) {
	response = CreateExecuteMultiAccountSQLQueryResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteMultiAccountSQLQueryWithChan invokes the resourcecenter.ExecuteMultiAccountSQLQuery API asynchronously
func (client *Client) ExecuteMultiAccountSQLQueryWithChan(request *ExecuteMultiAccountSQLQueryRequest) (<-chan *ExecuteMultiAccountSQLQueryResponse, <-chan error) {
	responseChan := make(chan *ExecuteMultiAccountSQLQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteMultiAccountSQLQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteMultiAccountSQLQueryWithCallback invokes the resourcecenter.ExecuteMultiAccountSQLQuery API asynchronously
func (client *Client) ExecuteMultiAccountSQLQueryWithCallback(request *ExecuteMultiAccountSQLQueryRequest, callback func(response *ExecuteMultiAccountSQLQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteMultiAccountSQLQueryResponse
		var err error
		defer close(result)
		response, err = client.ExecuteMultiAccountSQLQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteMultiAccountSQLQueryRequest is the request struct for api ExecuteMultiAccountSQLQuery
type ExecuteMultiAccountSQLQueryRequest struct {
	*requests.RpcRequest
	Expression string           `position:"Query" name:"Expression"`
	NextToken  string           `position:"Query" name:"NextToken"`
	Scope      string           `position:"Query" name:"Scope"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// ExecuteMultiAccountSQLQueryResponse is the response struct for api ExecuteMultiAccountSQLQuery
type ExecuteMultiAccountSQLQueryResponse struct {
	*responses.BaseResponse
	MaxResults int      `json:"MaxResults" xml:"MaxResults"`
	NextToken  string   `json:"NextToken" xml:"NextToken"`
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	Rows       []string `json:"Rows" xml:"Rows"`
	Columns    []Column `json:"Columns" xml:"Columns"`
}

// CreateExecuteMultiAccountSQLQueryRequest creates a request to invoke ExecuteMultiAccountSQLQuery API
func CreateExecuteMultiAccountSQLQueryRequest() (request *ExecuteMultiAccountSQLQueryRequest) {
	request = &ExecuteMultiAccountSQLQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "ExecuteMultiAccountSQLQuery", "", "")
	request.Method = requests.POST
	return
}

// CreateExecuteMultiAccountSQLQueryResponse creates a response to parse from ExecuteMultiAccountSQLQuery response
func CreateExecuteMultiAccountSQLQueryResponse() (response *ExecuteMultiAccountSQLQueryResponse) {
	response = &ExecuteMultiAccountSQLQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
