package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAutoGroupingRule invokes the resourcemanager.GetAutoGroupingRule API synchronously
func (client *Client) GetAutoGroupingRule(request *GetAutoGroupingRuleRequest) (response *GetAutoGroupingRuleResponse, err error) {
	response = CreateGetAutoGroupingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// GetAutoGroupingRuleWithChan invokes the resourcemanager.GetAutoGroupingRule API asynchronously
func (client *Client) GetAutoGroupingRuleWithChan(request *GetAutoGroupingRuleRequest) (<-chan *GetAutoGroupingRuleResponse, <-chan error) {
	responseChan := make(chan *GetAutoGroupingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAutoGroupingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAutoGroupingRuleWithCallback invokes the resourcemanager.GetAutoGroupingRule API asynchronously
func (client *Client) GetAutoGroupingRuleWithCallback(request *GetAutoGroupingRuleRequest, callback func(response *GetAutoGroupingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAutoGroupingRuleResponse
		var err error
		defer close(result)
		response, err = client.GetAutoGroupingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAutoGroupingRuleRequest is the request struct for api GetAutoGroupingRule
type GetAutoGroupingRuleRequest struct {
	*requests.RpcRequest
	RuleId string `position:"Query" name:"RuleId"`
}

// GetAutoGroupingRuleResponse is the response struct for api GetAutoGroupingRule
type GetAutoGroupingRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Rule      Rule   `json:"Rule" xml:"Rule"`
}

// CreateGetAutoGroupingRuleRequest creates a request to invoke GetAutoGroupingRule API
func CreateGetAutoGroupingRuleRequest() (request *GetAutoGroupingRuleRequest) {
	request = &GetAutoGroupingRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "GetAutoGroupingRule", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAutoGroupingRuleResponse creates a response to parse from GetAutoGroupingRule response
func CreateGetAutoGroupingRuleResponse() (response *GetAutoGroupingRuleResponse) {
	response = &GetAutoGroupingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
