package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAccount invokes the resourcemanager.UpdateAccount API synchronously
func (client *Client) UpdateAccount(request *UpdateAccountRequest) (response *UpdateAccountResponse, err error) {
	response = CreateUpdateAccountResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAccountWithChan invokes the resourcemanager.UpdateAccount API asynchronously
func (client *Client) UpdateAccountWithChan(request *UpdateAccountRequest) (<-chan *UpdateAccountResponse, <-chan error) {
	responseChan := make(chan *UpdateAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAccountWithCallback invokes the resourcemanager.UpdateAccount API asynchronously
func (client *Client) UpdateAccountWithCallback(request *UpdateAccountRequest, callback func(response *UpdateAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAccountResponse
		var err error
		defer close(result)
		response, err = client.UpdateAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAccountRequest is the request struct for api UpdateAccount
type UpdateAccountRequest struct {
	*requests.RpcRequest
	NewDisplayName string `position:"Query" name:"NewDisplayName"`
	NewAccountType string `position:"Query" name:"NewAccountType"`
	AccountId      string `position:"Query" name:"AccountId"`
}

// UpdateAccountResponse is the response struct for api UpdateAccount
type UpdateAccountResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Account   Account `json:"Account" xml:"Account"`
}

// CreateUpdateAccountRequest creates a request to invoke UpdateAccount API
func CreateUpdateAccountRequest() (request *UpdateAccountRequest) {
	request = &UpdateAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "UpdateAccount", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAccountResponse creates a response to parse from UpdateAccount response
func CreateUpdateAccountResponse() (response *UpdateAccountResponse) {
	response = &UpdateAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
