package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LoadDataToLabelDataSet invokes the retailadvqa_public.LoadDataToLabelDataSet API synchronously
func (client *Client) LoadDataToLabelDataSet(request *LoadDataToLabelDataSetRequest) (response *LoadDataToLabelDataSetResponse, err error) {
	response = CreateLoadDataToLabelDataSetResponse()
	err = client.DoAction(request, response)
	return
}

// LoadDataToLabelDataSetWithChan invokes the retailadvqa_public.LoadDataToLabelDataSet API asynchronously
func (client *Client) LoadDataToLabelDataSetWithChan(request *LoadDataToLabelDataSetRequest) (<-chan *LoadDataToLabelDataSetResponse, <-chan error) {
	responseChan := make(chan *LoadDataToLabelDataSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LoadDataToLabelDataSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LoadDataToLabelDataSetWithCallback invokes the retailadvqa_public.LoadDataToLabelDataSet API asynchronously
func (client *Client) LoadDataToLabelDataSetWithCallback(request *LoadDataToLabelDataSetRequest, callback func(response *LoadDataToLabelDataSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LoadDataToLabelDataSetResponse
		var err error
		defer close(result)
		response, err = client.LoadDataToLabelDataSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LoadDataToLabelDataSetRequest is the request struct for api LoadDataToLabelDataSet
type LoadDataToLabelDataSetRequest struct {
	*requests.RpcRequest
	AccessId    string    `position:"Query" name:"AccessId"`
	Separator   string    `position:"Query" name:"Separator"`
	OssPath     string    `position:"Query" name:"OssPath"`
	CubeId      string    `position:"Query" name:"CubeId"`
	ColNameList *[]string `position:"Query" name:"ColNameList"  type:"Repeated"`
}

// LoadDataToLabelDataSetResponse is the response struct for api LoadDataToLabelDataSet
type LoadDataToLabelDataSetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Data      bool   `json:"Data" xml:"Data"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	ExStack   string `json:"ExStack" xml:"ExStack"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateLoadDataToLabelDataSetRequest creates a request to invoke LoadDataToLabelDataSet API
func CreateLoadDataToLabelDataSetRequest() (request *LoadDataToLabelDataSetRequest) {
	request = &LoadDataToLabelDataSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "LoadDataToLabelDataSet", "", "")
	request.Method = requests.POST
	return
}

// CreateLoadDataToLabelDataSetResponse creates a response to parse from LoadDataToLabelDataSet response
func CreateLoadDataToLabelDataSetResponse() (response *LoadDataToLabelDataSetResponse) {
	response = &LoadDataToLabelDataSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
