package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GrantDbToAccount invokes the retailcloud.GrantDbToAccount API synchronously
func (client *Client) GrantDbToAccount(request *GrantDbToAccountRequest) (response *GrantDbToAccountResponse, err error) {
	response = CreateGrantDbToAccountResponse()
	err = client.DoAction(request, response)
	return
}

// GrantDbToAccountWithChan invokes the retailcloud.GrantDbToAccount API asynchronously
func (client *Client) GrantDbToAccountWithChan(request *GrantDbToAccountRequest) (<-chan *GrantDbToAccountResponse, <-chan error) {
	responseChan := make(chan *GrantDbToAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GrantDbToAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GrantDbToAccountWithCallback invokes the retailcloud.GrantDbToAccount API asynchronously
func (client *Client) GrantDbToAccountWithCallback(request *GrantDbToAccountRequest, callback func(response *GrantDbToAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GrantDbToAccountResponse
		var err error
		defer close(result)
		response, err = client.GrantDbToAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GrantDbToAccountRequest is the request struct for api GrantDbToAccount
type GrantDbToAccountRequest struct {
	*requests.RpcRequest
	AccountName      string `position:"Body" name:"AccountName"`
	DbName           string `position:"Body" name:"DbName"`
	DbInstanceId     string `position:"Body" name:"DbInstanceId"`
	AccountPrivilege string `position:"Body" name:"AccountPrivilege"`
}

// GrantDbToAccountResponse is the response struct for api GrantDbToAccount
type GrantDbToAccountResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
}

// CreateGrantDbToAccountRequest creates a request to invoke GrantDbToAccount API
func CreateGrantDbToAccountRequest() (request *GrantDbToAccountRequest) {
	request = &GrantDbToAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "GrantDbToAccount", "", "")
	request.Method = requests.POST
	return
}

// CreateGrantDbToAccountResponse creates a response to parse from GrantDbToAccount response
func CreateGrantDbToAccountResponse() (response *GrantDbToAccountResponse) {
	response = &GrantDbToAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
