package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDomainOriginBpsData invokes the scdn.DescribeScdnDomainOriginBpsData API synchronously
func (client *Client) DescribeScdnDomainOriginBpsData(request *DescribeScdnDomainOriginBpsDataRequest) (response *DescribeScdnDomainOriginBpsDataResponse, err error) {
	response = CreateDescribeScdnDomainOriginBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDomainOriginBpsDataWithChan invokes the scdn.DescribeScdnDomainOriginBpsData API asynchronously
func (client *Client) DescribeScdnDomainOriginBpsDataWithChan(request *DescribeScdnDomainOriginBpsDataRequest) (<-chan *DescribeScdnDomainOriginBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDomainOriginBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDomainOriginBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDomainOriginBpsDataWithCallback invokes the scdn.DescribeScdnDomainOriginBpsData API asynchronously
func (client *Client) DescribeScdnDomainOriginBpsDataWithCallback(request *DescribeScdnDomainOriginBpsDataRequest, callback func(response *DescribeScdnDomainOriginBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDomainOriginBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDomainOriginBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDomainOriginBpsDataRequest is the request struct for api DescribeScdnDomainOriginBpsData
type DescribeScdnDomainOriginBpsDataRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	EndTime    string `position:"Query" name:"EndTime"`
	Interval   string `position:"Query" name:"Interval"`
	StartTime  string `position:"Query" name:"StartTime"`
}

// DescribeScdnDomainOriginBpsDataResponse is the response struct for api DescribeScdnDomainOriginBpsData
type DescribeScdnDomainOriginBpsDataResponse struct {
	*responses.BaseResponse
	EndTime                  string                   `json:"EndTime" xml:"EndTime"`
	StartTime                string                   `json:"StartTime" xml:"StartTime"`
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	DomainName               string                   `json:"DomainName" xml:"DomainName"`
	DataInterval             string                   `json:"DataInterval" xml:"DataInterval"`
	OriginBpsDataPerInterval OriginBpsDataPerInterval `json:"OriginBpsDataPerInterval" xml:"OriginBpsDataPerInterval"`
}

// CreateDescribeScdnDomainOriginBpsDataRequest creates a request to invoke DescribeScdnDomainOriginBpsData API
func CreateDescribeScdnDomainOriginBpsDataRequest() (request *DescribeScdnDomainOriginBpsDataRequest) {
	request = &DescribeScdnDomainOriginBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDomainOriginBpsData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeScdnDomainOriginBpsDataResponse creates a response to parse from DescribeScdnDomainOriginBpsData response
func CreateDescribeScdnDomainOriginBpsDataResponse() (response *DescribeScdnDomainOriginBpsDataResponse) {
	response = &DescribeScdnDomainOriginBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
