package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeComponentPlaybook invokes the sophonsoar.DescribeComponentPlaybook API synchronously
func (client *Client) DescribeComponentPlaybook(request *DescribeComponentPlaybookRequest) (response *DescribeComponentPlaybookResponse, err error) {
	response = CreateDescribeComponentPlaybookResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeComponentPlaybookWithChan invokes the sophonsoar.DescribeComponentPlaybook API asynchronously
func (client *Client) DescribeComponentPlaybookWithChan(request *DescribeComponentPlaybookRequest) (<-chan *DescribeComponentPlaybookResponse, <-chan error) {
	responseChan := make(chan *DescribeComponentPlaybookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeComponentPlaybook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeComponentPlaybookWithCallback invokes the sophonsoar.DescribeComponentPlaybook API asynchronously
func (client *Client) DescribeComponentPlaybookWithCallback(request *DescribeComponentPlaybookRequest, callback func(response *DescribeComponentPlaybookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeComponentPlaybookResponse
		var err error
		defer close(result)
		response, err = client.DescribeComponentPlaybook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeComponentPlaybookRequest is the request struct for api DescribeComponentPlaybook
type DescribeComponentPlaybookRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	PlaybookUuid string `position:"Query" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeComponentPlaybookResponse is the response struct for api DescribeComponentPlaybook
type DescribeComponentPlaybookResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Playbooks []Data `json:"Playbooks" xml:"Playbooks"`
}

// CreateDescribeComponentPlaybookRequest creates a request to invoke DescribeComponentPlaybook API
func CreateDescribeComponentPlaybookRequest() (request *DescribeComponentPlaybookRequest) {
	request = &DescribeComponentPlaybookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeComponentPlaybook", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeComponentPlaybookResponse creates a response to parse from DescribeComponentPlaybook response
func CreateDescribeComponentPlaybookResponse() (response *DescribeComponentPlaybookResponse) {
	response = &DescribeComponentPlaybookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
