package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLatestRecordSchema invokes the sophonsoar.DescribeLatestRecordSchema API synchronously
func (client *Client) DescribeLatestRecordSchema(request *DescribeLatestRecordSchemaRequest) (response *DescribeLatestRecordSchemaResponse, err error) {
	response = CreateDescribeLatestRecordSchemaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLatestRecordSchemaWithChan invokes the sophonsoar.DescribeLatestRecordSchema API asynchronously
func (client *Client) DescribeLatestRecordSchemaWithChan(request *DescribeLatestRecordSchemaRequest) (<-chan *DescribeLatestRecordSchemaResponse, <-chan error) {
	responseChan := make(chan *DescribeLatestRecordSchemaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLatestRecordSchema(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLatestRecordSchemaWithCallback invokes the sophonsoar.DescribeLatestRecordSchema API asynchronously
func (client *Client) DescribeLatestRecordSchemaWithCallback(request *DescribeLatestRecordSchemaRequest, callback func(response *DescribeLatestRecordSchemaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLatestRecordSchemaResponse
		var err error
		defer close(result)
		response, err = client.DescribeLatestRecordSchema(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLatestRecordSchemaRequest is the request struct for api DescribeLatestRecordSchema
type DescribeLatestRecordSchemaRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	PlaybookUuid string `position:"Query" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeLatestRecordSchemaResponse is the response struct for api DescribeLatestRecordSchema
type DescribeLatestRecordSchemaResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	PlaybookNodeSchema PlaybookNodeSchema `json:"PlaybookNodeSchema" xml:"PlaybookNodeSchema"`
}

// CreateDescribeLatestRecordSchemaRequest creates a request to invoke DescribeLatestRecordSchema API
func CreateDescribeLatestRecordSchemaRequest() (request *DescribeLatestRecordSchemaRequest) {
	request = &DescribeLatestRecordSchemaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeLatestRecordSchema", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeLatestRecordSchemaResponse creates a response to parse from DescribeLatestRecordSchema response
func CreateDescribeLatestRecordSchemaResponse() (response *DescribeLatestRecordSchemaResponse) {
	response = &DescribeLatestRecordSchemaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
