package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePlaybookInputOutput invokes the sophonsoar.DescribePlaybookInputOutput API synchronously
func (client *Client) DescribePlaybookInputOutput(request *DescribePlaybookInputOutputRequest) (response *DescribePlaybookInputOutputResponse, err error) {
	response = CreateDescribePlaybookInputOutputResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePlaybookInputOutputWithChan invokes the sophonsoar.DescribePlaybookInputOutput API asynchronously
func (client *Client) DescribePlaybookInputOutputWithChan(request *DescribePlaybookInputOutputRequest) (<-chan *DescribePlaybookInputOutputResponse, <-chan error) {
	responseChan := make(chan *DescribePlaybookInputOutputResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePlaybookInputOutput(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePlaybookInputOutputWithCallback invokes the sophonsoar.DescribePlaybookInputOutput API asynchronously
func (client *Client) DescribePlaybookInputOutputWithCallback(request *DescribePlaybookInputOutputRequest, callback func(response *DescribePlaybookInputOutputResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePlaybookInputOutputResponse
		var err error
		defer close(result)
		response, err = client.DescribePlaybookInputOutput(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePlaybookInputOutputRequest is the request struct for api DescribePlaybookInputOutput
type DescribePlaybookInputOutputRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	ModelName    string `position:"Query" name:"ModelName"`
	PlaybookUuid string `position:"Query" name:"PlaybookUuid"`
	ModelCode    string `position:"Query" name:"ModelCode"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribePlaybookInputOutputResponse is the response struct for api DescribePlaybookInputOutput
type DescribePlaybookInputOutputResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Config    Config `json:"Config" xml:"Config"`
}

// CreateDescribePlaybookInputOutputRequest creates a request to invoke DescribePlaybookInputOutput API
func CreateDescribePlaybookInputOutputRequest() (request *DescribePlaybookInputOutputRequest) {
	request = &DescribePlaybookInputOutputRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribePlaybookInputOutput", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribePlaybookInputOutputResponse creates a response to parse from DescribePlaybookInputOutput response
func CreateDescribePlaybookInputOutputResponse() (response *DescribePlaybookInputOutputResponse) {
	response = &DescribePlaybookInputOutputResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
