package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSoarRecords invokes the sophonsoar.DescribeSoarRecords API synchronously
func (client *Client) DescribeSoarRecords(request *DescribeSoarRecordsRequest) (response *DescribeSoarRecordsResponse, err error) {
	response = CreateDescribeSoarRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSoarRecordsWithChan invokes the sophonsoar.DescribeSoarRecords API asynchronously
func (client *Client) DescribeSoarRecordsWithChan(request *DescribeSoarRecordsRequest) (<-chan *DescribeSoarRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeSoarRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSoarRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSoarRecordsWithCallback invokes the sophonsoar.DescribeSoarRecords API asynchronously
func (client *Client) DescribeSoarRecordsWithCallback(request *DescribeSoarRecordsRequest, callback func(response *DescribeSoarRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSoarRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSoarRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSoarRecordsRequest is the request struct for api DescribeSoarRecords
type DescribeSoarRecordsRequest struct {
	*requests.RpcRequest
	TaskflowMd5  string           `position:"Query" name:"TaskflowMd5"`
	RoleFor      string           `position:"Query" name:"RoleFor"`
	TaskType     string           `position:"Query" name:"TaskType"`
	EndMillis    requests.Integer `position:"Query" name:"EndMillis"`
	StartMillis  requests.Integer `position:"Query" name:"StartMillis"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	TaskStatus   string           `position:"Query" name:"TaskStatus"`
	PlaybookUuid string           `position:"Query" name:"PlaybookUuid"`
	RequestUuid  string           `position:"Query" name:"RequestUuid"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	RoleType     string           `position:"Query" name:"RoleType"`
	TriggerUser  string           `position:"Query" name:"TriggerUser"`
	Lang         string           `position:"Query" name:"Lang"`
}

// DescribeSoarRecordsResponse is the response struct for api DescribeSoarRecords
type DescribeSoarRecordsResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	Page               Page   `json:"Page" xml:"Page"`
	SoarExecuteRecords []Data `json:"SoarExecuteRecords" xml:"SoarExecuteRecords"`
}

// CreateDescribeSoarRecordsRequest creates a request to invoke DescribeSoarRecords API
func CreateDescribeSoarRecordsRequest() (request *DescribeSoarRecordsRequest) {
	request = &DescribeSoarRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeSoarRecords", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeSoarRecordsResponse creates a response to parse from DescribeSoarRecords response
func CreateDescribeSoarRecordsResponse() (response *DescribeSoarRecordsResponse) {
	response = &DescribeSoarRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
