package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFirewallTemplate invokes the swas_open.CreateFirewallTemplate API synchronously
func (client *Client) CreateFirewallTemplate(request *CreateFirewallTemplateRequest) (response *CreateFirewallTemplateResponse, err error) {
	response = CreateCreateFirewallTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFirewallTemplateWithChan invokes the swas_open.CreateFirewallTemplate API asynchronously
func (client *Client) CreateFirewallTemplateWithChan(request *CreateFirewallTemplateRequest) (<-chan *CreateFirewallTemplateResponse, <-chan error) {
	responseChan := make(chan *CreateFirewallTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFirewallTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFirewallTemplateWithCallback invokes the swas_open.CreateFirewallTemplate API asynchronously
func (client *Client) CreateFirewallTemplateWithCallback(request *CreateFirewallTemplateRequest, callback func(response *CreateFirewallTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFirewallTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreateFirewallTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFirewallTemplateRequest is the request struct for api CreateFirewallTemplate
type CreateFirewallTemplateRequest struct {
	*requests.RpcRequest
	Description  string                                `position:"Query" name:"Description"`
	Name         string                                `position:"Query" name:"Name"`
	FirewallRule *[]CreateFirewallTemplateFirewallRule `position:"Query" name:"FirewallRule"  type:"Repeated"`
}

// CreateFirewallTemplateFirewallRule is a repeated param struct in CreateFirewallTemplateRequest
type CreateFirewallTemplateFirewallRule struct {
	RuleProtocol string `name:"RuleProtocol"`
	Port         string `name:"Port"`
	SourceCidrIp string `name:"SourceCidrIp"`
	Remark       string `name:"Remark"`
}

// CreateFirewallTemplateResponse is the response struct for api CreateFirewallTemplate
type CreateFirewallTemplateResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	FirewallTemplateId string `json:"FirewallTemplateId" xml:"FirewallTemplateId"`
}

// CreateCreateFirewallTemplateRequest creates a request to invoke CreateFirewallTemplate API
func CreateCreateFirewallTemplateRequest() (request *CreateFirewallTemplateRequest) {
	request = &CreateFirewallTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "CreateFirewallTemplate", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateFirewallTemplateResponse creates a response to parse from CreateFirewallTemplate response
func CreateCreateFirewallTemplateResponse() (response *CreateFirewallTemplateResponse) {
	response = &CreateFirewallTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
