package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadInstanceKeyPair invokes the swas_open.UploadInstanceKeyPair API synchronously
func (client *Client) UploadInstanceKeyPair(request *UploadInstanceKeyPairRequest) (response *UploadInstanceKeyPairResponse, err error) {
	response = CreateUploadInstanceKeyPairResponse()
	err = client.DoAction(request, response)
	return
}

// UploadInstanceKeyPairWithChan invokes the swas_open.UploadInstanceKeyPair API asynchronously
func (client *Client) UploadInstanceKeyPairWithChan(request *UploadInstanceKeyPairRequest) (<-chan *UploadInstanceKeyPairResponse, <-chan error) {
	responseChan := make(chan *UploadInstanceKeyPairResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadInstanceKeyPair(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadInstanceKeyPairWithCallback invokes the swas_open.UploadInstanceKeyPair API asynchronously
func (client *Client) UploadInstanceKeyPairWithCallback(request *UploadInstanceKeyPairRequest, callback func(response *UploadInstanceKeyPairResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadInstanceKeyPairResponse
		var err error
		defer close(result)
		response, err = client.UploadInstanceKeyPair(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadInstanceKeyPairRequest is the request struct for api UploadInstanceKeyPair
type UploadInstanceKeyPairRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	PublicKey   string `position:"Query" name:"PublicKey"`
	KeyPairName string `position:"Query" name:"KeyPairName"`
	InstanceId  string `position:"Query" name:"InstanceId"`
}

// UploadInstanceKeyPairResponse is the response struct for api UploadInstanceKeyPair
type UploadInstanceKeyPairResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUploadInstanceKeyPairRequest creates a request to invoke UploadInstanceKeyPair API
func CreateUploadInstanceKeyPairRequest() (request *UploadInstanceKeyPairRequest) {
	request = &UploadInstanceKeyPairRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "UploadInstanceKeyPair", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUploadInstanceKeyPairResponse creates a response to parse from UploadInstanceKeyPair response
func CreateUploadInstanceKeyPairResponse() (response *UploadInstanceKeyPairResponse) {
	response = &UploadInstanceKeyPairResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
