package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTaskRules invokes the unimkt.QueryTaskRules API synchronously
func (client *Client) QueryTaskRules(request *QueryTaskRulesRequest) (response *QueryTaskRulesResponse, err error) {
	response = CreateQueryTaskRulesResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTaskRulesWithChan invokes the unimkt.QueryTaskRules API asynchronously
func (client *Client) QueryTaskRulesWithChan(request *QueryTaskRulesRequest) (<-chan *QueryTaskRulesResponse, <-chan error) {
	responseChan := make(chan *QueryTaskRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTaskRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTaskRulesWithCallback invokes the unimkt.QueryTaskRules API asynchronously
func (client *Client) QueryTaskRulesWithCallback(request *QueryTaskRulesRequest, callback func(response *QueryTaskRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTaskRulesResponse
		var err error
		defer close(result)
		response, err = client.QueryTaskRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTaskRulesRequest is the request struct for api QueryTaskRules
type QueryTaskRulesRequest struct {
	*requests.RpcRequest
	TaskRuleType string           `position:"Query" name:"TaskRuleType"`
	TaskId       requests.Integer `position:"Query" name:"TaskId"`
}

// QueryTaskRulesResponse is the response struct for api QueryTaskRules
type QueryTaskRulesResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	Code         int        `json:"Code" xml:"Code"`
	Success      bool       `json:"Success" xml:"Success"`
	ErrorMessage string     `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryTaskRulesRequest creates a request to invoke QueryTaskRules API
func CreateQueryTaskRulesRequest() (request *QueryTaskRulesRequest) {
	request = &QueryTaskRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryTaskRules", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTaskRulesResponse creates a response to parse from QueryTaskRules response
func CreateQueryTaskRulesResponse() (response *QueryTaskRulesResponse) {
	response = &QueryTaskRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
