package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResourcePlan invokes the ververica.GetResourcePlan API synchronously
func (client *Client) GetResourcePlan(request *GetResourcePlanRequest) (response *GetResourcePlanResponse, err error) {
	response = CreateGetResourcePlanResponse()
	err = client.DoAction(request, response)
	return
}

// GetResourcePlanWithChan invokes the ververica.GetResourcePlan API asynchronously
func (client *Client) GetResourcePlanWithChan(request *GetResourcePlanRequest) (<-chan *GetResourcePlanResponse, <-chan error) {
	responseChan := make(chan *GetResourcePlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResourcePlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResourcePlanWithCallback invokes the ververica.GetResourcePlan API asynchronously
func (client *Client) GetResourcePlanWithCallback(request *GetResourcePlanRequest, callback func(response *GetResourcePlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResourcePlanResponse
		var err error
		defer close(result)
		response, err = client.GetResourcePlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResourcePlanRequest is the request struct for api GetResourcePlan
type GetResourcePlanRequest struct {
	*requests.RoaRequest
	Workspace    string `position:"Path" name:"workspace"`
	DeploymentId string `position:"Path" name:"deploymentId"`
	Namespace    string `position:"Path" name:"namespace"`
}

// GetResourcePlanResponse is the response struct for api GetResourcePlan
type GetResourcePlanResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateGetResourcePlanRequest creates a request to invoke GetResourcePlan API
func CreateGetResourcePlanRequest() (request *GetResourcePlanRequest) {
	request = &GetResourcePlanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "GetResourcePlan", "/pop/workspaces/[workspace]/api/v1/namespaces/[namespace]/deployments/[deploymentId]/resource_plan", "", "")
	request.Method = requests.GET
	return
}

// CreateGetResourcePlanResponse creates a response to parse from GetResourcePlan response
func CreateGetResourcePlanResponse() (response *GetResourcePlanResponse) {
	response = &GetResourcePlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
