package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWorkspace invokes the viapi_regen.UpdateWorkspace API synchronously
func (client *Client) UpdateWorkspace(request *UpdateWorkspaceRequest) (response *UpdateWorkspaceResponse, err error) {
	response = CreateUpdateWorkspaceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWorkspaceWithChan invokes the viapi_regen.UpdateWorkspace API asynchronously
func (client *Client) UpdateWorkspaceWithChan(request *UpdateWorkspaceRequest) (<-chan *UpdateWorkspaceResponse, <-chan error) {
	responseChan := make(chan *UpdateWorkspaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWorkspace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWorkspaceWithCallback invokes the viapi_regen.UpdateWorkspace API asynchronously
func (client *Client) UpdateWorkspaceWithCallback(request *UpdateWorkspaceRequest, callback func(response *UpdateWorkspaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWorkspaceResponse
		var err error
		defer close(result)
		response, err = client.UpdateWorkspace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWorkspaceRequest is the request struct for api UpdateWorkspace
type UpdateWorkspaceRequest struct {
	*requests.RpcRequest
	Description string           `position:"Body" name:"Description"`
	Id          requests.Integer `position:"Body" name:"Id"`
	Name        string           `position:"Body" name:"Name"`
}

// UpdateWorkspaceResponse is the response struct for api UpdateWorkspace
type UpdateWorkspaceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdateWorkspaceRequest creates a request to invoke UpdateWorkspace API
func CreateUpdateWorkspaceRequest() (request *UpdateWorkspaceRequest) {
	request = &UpdateWorkspaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "UpdateWorkspace", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateWorkspaceResponse creates a response to parse from UpdateWorkspace response
func CreateUpdateWorkspaceResponse() (response *UpdateWorkspaceResponse) {
	response = &UpdateWorkspaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
