package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddVodStorageForApp invokes the vod.AddVodStorageForApp API synchronously
func (client *Client) AddVodStorageForApp(request *AddVodStorageForAppRequest) (response *AddVodStorageForAppResponse, err error) {
	response = CreateAddVodStorageForAppResponse()
	err = client.DoAction(request, response)
	return
}

// AddVodStorageForAppWithChan invokes the vod.AddVodStorageForApp API asynchronously
func (client *Client) AddVodStorageForAppWithChan(request *AddVodStorageForAppRequest) (<-chan *AddVodStorageForAppResponse, <-chan error) {
	responseChan := make(chan *AddVodStorageForAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddVodStorageForApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddVodStorageForAppWithCallback invokes the vod.AddVodStorageForApp API asynchronously
func (client *Client) AddVodStorageForAppWithCallback(request *AddVodStorageForAppRequest, callback func(response *AddVodStorageForAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddVodStorageForAppResponse
		var err error
		defer close(result)
		response, err = client.AddVodStorageForApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddVodStorageForAppRequest is the request struct for api AddVodStorageForApp
type AddVodStorageForAppRequest struct {
	*requests.RpcRequest
	ResourceRealOwnerId requests.Integer `position:"Query" name:"ResourceRealOwnerId"`
	StorageType         string           `position:"Query" name:"StorageType"`
	StorageLocation     string           `position:"Query" name:"StorageLocation"`
	AppId               string           `position:"Query" name:"AppId"`
}

// AddVodStorageForAppResponse is the response struct for api AddVodStorageForApp
type AddVodStorageForAppResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	StorageLocation string `json:"StorageLocation" xml:"StorageLocation"`
}

// CreateAddVodStorageForAppRequest creates a request to invoke AddVodStorageForApp API
func CreateAddVodStorageForAppRequest() (request *AddVodStorageForAppRequest) {
	request = &AddVodStorageForAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "AddVodStorageForApp", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddVodStorageForAppResponse creates a response to parse from AddVodStorageForApp response
func CreateAddVodStorageForAppResponse() (response *AddVodStorageForAppResponse) {
	response = &AddVodStorageForAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
