package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainRealTimeDetailData invokes the vod.DescribeVodDomainRealTimeDetailData API synchronously
func (client *Client) DescribeVodDomainRealTimeDetailData(request *DescribeVodDomainRealTimeDetailDataRequest) (response *DescribeVodDomainRealTimeDetailDataResponse, err error) {
	response = CreateDescribeVodDomainRealTimeDetailDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainRealTimeDetailDataWithChan invokes the vod.DescribeVodDomainRealTimeDetailData API asynchronously
func (client *Client) DescribeVodDomainRealTimeDetailDataWithChan(request *DescribeVodDomainRealTimeDetailDataRequest) (<-chan *DescribeVodDomainRealTimeDetailDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainRealTimeDetailDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainRealTimeDetailData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainRealTimeDetailDataWithCallback invokes the vod.DescribeVodDomainRealTimeDetailData API asynchronously
func (client *Client) DescribeVodDomainRealTimeDetailDataWithCallback(request *DescribeVodDomainRealTimeDetailDataRequest, callback func(response *DescribeVodDomainRealTimeDetailDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainRealTimeDetailDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainRealTimeDetailData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainRealTimeDetailDataRequest is the request struct for api DescribeVodDomainRealTimeDetailData
type DescribeVodDomainRealTimeDetailDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	Merge          string           `position:"Query" name:"Merge"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	MergeLocIsp    string           `position:"Query" name:"MergeLocIsp"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Field          string           `position:"Query" name:"Field"`
}

// DescribeVodDomainRealTimeDetailDataResponse is the response struct for api DescribeVodDomainRealTimeDetailData
type DescribeVodDomainRealTimeDetailDataResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeVodDomainRealTimeDetailDataRequest creates a request to invoke DescribeVodDomainRealTimeDetailData API
func CreateDescribeVodDomainRealTimeDetailDataRequest() (request *DescribeVodDomainRealTimeDetailDataRequest) {
	request = &DescribeVodDomainRealTimeDetailDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainRealTimeDetailData", "vod", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeVodDomainRealTimeDetailDataResponse creates a response to parse from DescribeVodDomainRealTimeDetailData response
func CreateDescribeVodDomainRealTimeDetailDataResponse() (response *DescribeVodDomainRealTimeDetailDataResponse) {
	response = &DescribeVodDomainRealTimeDetailDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
