package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainSrcTrafficData invokes the vod.DescribeVodDomainSrcTrafficData API synchronously
func (client *Client) DescribeVodDomainSrcTrafficData(request *DescribeVodDomainSrcTrafficDataRequest) (response *DescribeVodDomainSrcTrafficDataResponse, err error) {
	response = CreateDescribeVodDomainSrcTrafficDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainSrcTrafficDataWithChan invokes the vod.DescribeVodDomainSrcTrafficData API asynchronously
func (client *Client) DescribeVodDomainSrcTrafficDataWithChan(request *DescribeVodDomainSrcTrafficDataRequest) (<-chan *DescribeVodDomainSrcTrafficDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainSrcTrafficDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainSrcTrafficData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainSrcTrafficDataWithCallback invokes the vod.DescribeVodDomainSrcTrafficData API asynchronously
func (client *Client) DescribeVodDomainSrcTrafficDataWithCallback(request *DescribeVodDomainSrcTrafficDataRequest, callback func(response *DescribeVodDomainSrcTrafficDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainSrcTrafficDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainSrcTrafficData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainSrcTrafficDataRequest is the request struct for api DescribeVodDomainSrcTrafficData
type DescribeVodDomainSrcTrafficDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Interval   string           `position:"Query" name:"Interval"`
}

// DescribeVodDomainSrcTrafficDataResponse is the response struct for api DescribeVodDomainSrcTrafficData
type DescribeVodDomainSrcTrafficDataResponse struct {
	*responses.BaseResponse
	EndTime                   string                    `json:"EndTime" xml:"EndTime"`
	StartTime                 string                    `json:"StartTime" xml:"StartTime"`
	RequestId                 string                    `json:"RequestId" xml:"RequestId"`
	DomainName                string                    `json:"DomainName" xml:"DomainName"`
	TotalTraffic              string                    `json:"TotalTraffic" xml:"TotalTraffic"`
	DataInterval              string                    `json:"DataInterval" xml:"DataInterval"`
	SrcTrafficDataPerInterval SrcTrafficDataPerInterval `json:"SrcTrafficDataPerInterval" xml:"SrcTrafficDataPerInterval"`
}

// CreateDescribeVodDomainSrcTrafficDataRequest creates a request to invoke DescribeVodDomainSrcTrafficData API
func CreateDescribeVodDomainSrcTrafficDataRequest() (request *DescribeVodDomainSrcTrafficDataRequest) {
	request = &DescribeVodDomainSrcTrafficDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainSrcTrafficData", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVodDomainSrcTrafficDataResponse creates a response to parse from DescribeVodDomainSrcTrafficData response
func CreateDescribeVodDomainSrcTrafficDataResponse() (response *DescribeVodDomainSrcTrafficDataResponse) {
	response = &DescribeVodDomainSrcTrafficDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
