package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVpcPrefixList invokes the vpc.CreateVpcPrefixList API synchronously
func (client *Client) CreateVpcPrefixList(request *CreateVpcPrefixListRequest) (response *CreateVpcPrefixListResponse, err error) {
	response = CreateCreateVpcPrefixListResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVpcPrefixListWithChan invokes the vpc.CreateVpcPrefixList API asynchronously
func (client *Client) CreateVpcPrefixListWithChan(request *CreateVpcPrefixListRequest) (<-chan *CreateVpcPrefixListResponse, <-chan error) {
	responseChan := make(chan *CreateVpcPrefixListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVpcPrefixList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVpcPrefixListWithCallback invokes the vpc.CreateVpcPrefixList API asynchronously
func (client *Client) CreateVpcPrefixListWithCallback(request *CreateVpcPrefixListRequest, callback func(response *CreateVpcPrefixListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVpcPrefixListResponse
		var err error
		defer close(result)
		response, err = client.CreateVpcPrefixList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVpcPrefixListRequest is the request struct for api CreateVpcPrefixList
type CreateVpcPrefixListRequest struct {
	*requests.RpcRequest
	PrefixListEntrys      *[]CreateVpcPrefixListPrefixListEntrys  `position:"Query" name:"PrefixListEntrys"  type:"Repeated"`
	ResourceOwnerId       requests.Integer                        `position:"Query" name:"ResourceOwnerId"`
	ClientToken           string                                  `position:"Query" name:"ClientToken"`
	MaxEntries            requests.Integer                        `position:"Query" name:"MaxEntries"`
	ResourceGroupId       string                                  `position:"Query" name:"ResourceGroupId"`
	IpVersion             string                                  `position:"Query" name:"IpVersion"`
	PrefixListEntries     *[]CreateVpcPrefixListPrefixListEntries `position:"Query" name:"PrefixListEntries"  type:"Repeated"`
	Tag                   *[]CreateVpcPrefixListTag               `position:"Query" name:"Tag"  type:"Repeated"`
	DryRun                requests.Boolean                        `position:"Query" name:"DryRun"`
	ResourceOwnerAccount  string                                  `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string                                  `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer                        `position:"Query" name:"OwnerId"`
	PrefixListName        string                                  `position:"Query" name:"PrefixListName"`
	PrefixListDescription string                                  `position:"Query" name:"PrefixListDescription"`
}

// CreateVpcPrefixListPrefixListEntrys is a repeated param struct in CreateVpcPrefixListRequest
type CreateVpcPrefixListPrefixListEntrys struct {
	Cidr        string `name:"Cidr"`
	Description string `name:"Description"`
}

// CreateVpcPrefixListPrefixListEntries is a repeated param struct in CreateVpcPrefixListRequest
type CreateVpcPrefixListPrefixListEntries struct {
	Cidr        string `name:"Cidr"`
	Description string `name:"Description"`
}

// CreateVpcPrefixListTag is a repeated param struct in CreateVpcPrefixListRequest
type CreateVpcPrefixListTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateVpcPrefixListResponse is the response struct for api CreateVpcPrefixList
type CreateVpcPrefixListResponse struct {
	*responses.BaseResponse
	PrefixListId    string `json:"PrefixListId" xml:"PrefixListId"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ResourceGroupId string `json:"ResourceGroupId" xml:"ResourceGroupId"`
}

// CreateCreateVpcPrefixListRequest creates a request to invoke CreateVpcPrefixList API
func CreateCreateVpcPrefixListRequest() (request *CreateVpcPrefixListRequest) {
	request = &CreateVpcPrefixListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateVpcPrefixList", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVpcPrefixListResponse creates a response to parse from CreateVpcPrefixList response
func CreateCreateVpcPrefixListResponse() (response *CreateVpcPrefixListResponse) {
	response = &CreateVpcPrefixListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
