package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpnCrossAccountAuthorizations invokes the vpc.DescribeVpnCrossAccountAuthorizations API synchronously
func (client *Client) DescribeVpnCrossAccountAuthorizations(request *DescribeVpnCrossAccountAuthorizationsRequest) (response *DescribeVpnCrossAccountAuthorizationsResponse, err error) {
	response = CreateDescribeVpnCrossAccountAuthorizationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpnCrossAccountAuthorizationsWithChan invokes the vpc.DescribeVpnCrossAccountAuthorizations API asynchronously
func (client *Client) DescribeVpnCrossAccountAuthorizationsWithChan(request *DescribeVpnCrossAccountAuthorizationsRequest) (<-chan *DescribeVpnCrossAccountAuthorizationsResponse, <-chan error) {
	responseChan := make(chan *DescribeVpnCrossAccountAuthorizationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpnCrossAccountAuthorizations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpnCrossAccountAuthorizationsWithCallback invokes the vpc.DescribeVpnCrossAccountAuthorizations API asynchronously
func (client *Client) DescribeVpnCrossAccountAuthorizationsWithCallback(request *DescribeVpnCrossAccountAuthorizationsRequest, callback func(response *DescribeVpnCrossAccountAuthorizationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpnCrossAccountAuthorizationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpnCrossAccountAuthorizations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpnCrossAccountAuthorizationsRequest is the request struct for api DescribeVpnCrossAccountAuthorizations
type DescribeVpnCrossAccountAuthorizationsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	VpnConnectionId      string           `position:"Query" name:"VpnConnectionId"`
}

// DescribeVpnCrossAccountAuthorizationsResponse is the response struct for api DescribeVpnCrossAccountAuthorizations
type DescribeVpnCrossAccountAuthorizationsResponse struct {
	*responses.BaseResponse
	RequestId                  string                      `json:"RequestId" xml:"RequestId"`
	TotalCount                 int                         `json:"TotalCount" xml:"TotalCount"`
	PageNumber                 int                         `json:"PageNumber" xml:"PageNumber"`
	PageSize                   int                         `json:"PageSize" xml:"PageSize"`
	CrossAccountAuthorizations []CrossAccountAuthorization `json:"CrossAccountAuthorizations" xml:"CrossAccountAuthorizations"`
}

// CreateDescribeVpnCrossAccountAuthorizationsRequest creates a request to invoke DescribeVpnCrossAccountAuthorizations API
func CreateDescribeVpnCrossAccountAuthorizationsRequest() (request *DescribeVpnCrossAccountAuthorizationsRequest) {
	request = &DescribeVpnCrossAccountAuthorizationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeVpnCrossAccountAuthorizations", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpnCrossAccountAuthorizationsResponse creates a response to parse from DescribeVpnCrossAccountAuthorizations response
func CreateDescribeVpnCrossAccountAuthorizationsResponse() (response *DescribeVpnCrossAccountAuthorizationsResponse) {
	response = &DescribeVpnCrossAccountAuthorizationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
