package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTunnelAttribute invokes the vpc.ModifyTunnelAttribute API synchronously
func (client *Client) ModifyTunnelAttribute(request *ModifyTunnelAttributeRequest) (response *ModifyTunnelAttributeResponse, err error) {
	response = CreateModifyTunnelAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTunnelAttributeWithChan invokes the vpc.ModifyTunnelAttribute API asynchronously
func (client *Client) ModifyTunnelAttributeWithChan(request *ModifyTunnelAttributeRequest) (<-chan *ModifyTunnelAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyTunnelAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTunnelAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTunnelAttributeWithCallback invokes the vpc.ModifyTunnelAttribute API asynchronously
func (client *Client) ModifyTunnelAttributeWithCallback(request *ModifyTunnelAttributeRequest, callback func(response *ModifyTunnelAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTunnelAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyTunnelAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTunnelAttributeRequest is the request struct for api ModifyTunnelAttribute
type ModifyTunnelAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId            requests.Integer                                `position:"Query" name:"ResourceOwnerId"`
	ClientToken                string                                          `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount       string                                          `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount               string                                          `position:"Query" name:"OwnerAccount"`
	OwnerId                    requests.Integer                                `position:"Query" name:"OwnerId"`
	TunnelOptionsSpecification ModifyTunnelAttributeTunnelOptionsSpecification `position:"Query" name:"TunnelOptionsSpecification"  type:"Struct"`
	VpnConnectionId            string                                          `position:"Query" name:"VpnConnectionId"`
	TunnelId                   string                                          `position:"Query" name:"TunnelId"`
}

// ModifyTunnelAttributeTunnelOptionsSpecification is a repeated param struct in ModifyTunnelAttributeRequest
type ModifyTunnelAttributeTunnelOptionsSpecification struct {
	TunnelIpsecConfig   ModifyTunnelAttributeTunnelOptionsSpecificationTunnelIpsecConfig `name:"TunnelIpsecConfig" type:"Struct"`
	TunnelBgpConfig     ModifyTunnelAttributeTunnelOptionsSpecificationTunnelBgpConfig   `name:"TunnelBgpConfig" type:"Struct"`
	RemoteCaCertificate string                                                           `name:"RemoteCaCertificate"`
	TunnelIkeConfig     ModifyTunnelAttributeTunnelOptionsSpecificationTunnelIkeConfig   `name:"TunnelIkeConfig" type:"Struct"`
	EnableNatTraversal  string                                                           `name:"EnableNatTraversal"`
	EnableDpd           string                                                           `name:"EnableDpd"`
	CustomerGatewayId   string                                                           `name:"CustomerGatewayId"`
}

// ModifyTunnelAttributeTunnelOptionsSpecificationTunnelIpsecConfig is a repeated param struct in ModifyTunnelAttributeRequest
type ModifyTunnelAttributeTunnelOptionsSpecificationTunnelIpsecConfig struct {
	IpsecPfs      string `name:"IpsecPfs"`
	IpsecLifetime string `name:"IpsecLifetime"`
	IpsecAuthAlg  string `name:"IpsecAuthAlg"`
	IpsecEncAlg   string `name:"IpsecEncAlg"`
}

// ModifyTunnelAttributeTunnelOptionsSpecificationTunnelBgpConfig is a repeated param struct in ModifyTunnelAttributeRequest
type ModifyTunnelAttributeTunnelOptionsSpecificationTunnelBgpConfig struct {
	LocalAsn   string `name:"LocalAsn"`
	TunnelCidr string `name:"TunnelCidr"`
	LocalBgpIp string `name:"LocalBgpIp"`
}

// ModifyTunnelAttributeTunnelOptionsSpecificationTunnelIkeConfig is a repeated param struct in ModifyTunnelAttributeRequest
type ModifyTunnelAttributeTunnelOptionsSpecificationTunnelIkeConfig struct {
	IkeVersion  string `name:"IkeVersion"`
	IkeMode     string `name:"IkeMode"`
	IkeAuthAlg  string `name:"IkeAuthAlg"`
	Psk         string `name:"Psk"`
	IkePfs      string `name:"IkePfs"`
	IkeLifetime string `name:"IkeLifetime"`
	LocalId     string `name:"LocalId"`
	IkeEncAlg   string `name:"IkeEncAlg"`
	RemoteId    string `name:"RemoteId"`
}

// ModifyTunnelAttributeResponse is the response struct for api ModifyTunnelAttribute
type ModifyTunnelAttributeResponse struct {
	*responses.BaseResponse
	TunnelId            string                                   `json:"TunnelId" xml:"TunnelId"`
	RequestId           string                                   `json:"RequestId" xml:"RequestId"`
	EnableNatTraversal  bool                                     `json:"EnableNatTraversal" xml:"EnableNatTraversal"`
	EnableDpd           bool                                     `json:"EnableDpd" xml:"EnableDpd"`
	RemoteCaCertificate string                                   `json:"RemoteCaCertificate" xml:"RemoteCaCertificate"`
	CustomerGatewayId   string                                   `json:"CustomerGatewayId" xml:"CustomerGatewayId"`
	Role                string                                   `json:"Role" xml:"Role"`
	ZoneNo              string                                   `json:"ZoneNo" xml:"ZoneNo"`
	InternetIp          string                                   `json:"InternetIp" xml:"InternetIp"`
	State               string                                   `json:"State" xml:"State"`
	TunnelIkeConfig     TunnelIkeConfigInModifyTunnelAttribute   `json:"TunnelIkeConfig" xml:"TunnelIkeConfig"`
	TunnelIpsecConfig   TunnelIpsecConfigInModifyTunnelAttribute `json:"TunnelIpsecConfig" xml:"TunnelIpsecConfig"`
	TunnelBgpConfig     TunnelBgpConfigInModifyTunnelAttribute   `json:"TunnelBgpConfig" xml:"TunnelBgpConfig"`
}

// CreateModifyTunnelAttributeRequest creates a request to invoke ModifyTunnelAttribute API
func CreateModifyTunnelAttributeRequest() (request *ModifyTunnelAttributeRequest) {
	request = &ModifyTunnelAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyTunnelAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTunnelAttributeResponse creates a response to parse from ModifyTunnelAttribute response
func CreateModifyTunnelAttributeResponse() (response *ModifyTunnelAttributeResponse) {
	response = &ModifyTunnelAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
