package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRules invokes the waf_openapi.DescribeRules API synchronously
func (client *Client) DescribeRules(request *DescribeRulesRequest) (response *DescribeRulesResponse, err error) {
	response = CreateDescribeRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRulesWithChan invokes the waf_openapi.DescribeRules API asynchronously
func (client *Client) DescribeRulesWithChan(request *DescribeRulesRequest) (<-chan *DescribeRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRulesWithCallback invokes the waf_openapi.DescribeRules API asynchronously
func (client *Client) DescribeRulesWithCallback(request *DescribeRulesRequest, callback func(response *DescribeRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRulesRequest is the request struct for api DescribeRules
type DescribeRulesRequest struct {
	*requests.RpcRequest
	RuleGroupId     requests.Integer `position:"Query" name:"RuleGroupId"`
	ProtectionType  requests.Integer `position:"Query" name:"ProtectionType"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	CveIdKey        string           `position:"Query" name:"CveIdKey"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	Lang            string           `position:"Query" name:"Lang"`
	RiskLevel       requests.Integer `position:"Query" name:"RiskLevel"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	RuleIdKey       string           `position:"Query" name:"RuleIdKey"`
	Region          string           `position:"Query" name:"Region"`
	ApplicationType requests.Integer `position:"Query" name:"ApplicationType"`
}

// DescribeRulesResponse is the response struct for api DescribeRules
type DescribeRulesResponse struct {
	*responses.BaseResponse
	RuleGroupTemplateId   string      `json:"RuleGroupTemplateId" xml:"RuleGroupTemplateId"`
	RuleGroupName         string      `json:"RuleGroupName" xml:"RuleGroupName"`
	RequestId             string      `json:"RequestId" xml:"RequestId"`
	TotalCount            int         `json:"TotalCount" xml:"TotalCount"`
	RuleGroupTemplateName string      `json:"RuleGroupTemplateName" xml:"RuleGroupTemplateName"`
	IsSubscribe           int64       `json:"IsSubscribe" xml:"IsSubscribe"`
	Rules                 []RulesItem `json:"Rules" xml:"Rules"`
}

// CreateDescribeRulesRequest creates a request to invoke DescribeRules API
func CreateDescribeRulesRequest() (request *DescribeRulesRequest) {
	request = &DescribeRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "DescribeRules", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRulesResponse creates a response to parse from DescribeRules response
func CreateDescribeRulesResponse() (response *DescribeRulesResponse) {
	response = &DescribeRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
