package actiontrail

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDeliveryHistoryJob invokes the actiontrail.GetDeliveryHistoryJob API synchronously
func (client *Client) GetDeliveryHistoryJob(request *GetDeliveryHistoryJobRequest) (response *GetDeliveryHistoryJobResponse, err error) {
	response = CreateGetDeliveryHistoryJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetDeliveryHistoryJobWithChan invokes the actiontrail.GetDeliveryHistoryJob API asynchronously
func (client *Client) GetDeliveryHistoryJobWithChan(request *GetDeliveryHistoryJobRequest) (<-chan *GetDeliveryHistoryJobResponse, <-chan error) {
	responseChan := make(chan *GetDeliveryHistoryJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDeliveryHistoryJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDeliveryHistoryJobWithCallback invokes the actiontrail.GetDeliveryHistoryJob API asynchronously
func (client *Client) GetDeliveryHistoryJobWithCallback(request *GetDeliveryHistoryJobRequest, callback func(response *GetDeliveryHistoryJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDeliveryHistoryJobResponse
		var err error
		defer close(result)
		response, err = client.GetDeliveryHistoryJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDeliveryHistoryJobRequest is the request struct for api GetDeliveryHistoryJob
type GetDeliveryHistoryJobRequest struct {
	*requests.RpcRequest
	JobId requests.Integer `position:"Query" name:"JobId"`
}

// GetDeliveryHistoryJobResponse is the response struct for api GetDeliveryHistoryJob
type GetDeliveryHistoryJobResponse struct {
	*responses.BaseResponse
	JobStatus   int          `json:"JobStatus" xml:"JobStatus"`
	CreatedTime string       `json:"CreatedTime" xml:"CreatedTime"`
	EndTime     string       `json:"EndTime" xml:"EndTime"`
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	StartTime   string       `json:"StartTime" xml:"StartTime"`
	TrailName   string       `json:"TrailName" xml:"TrailName"`
	UpdatedTime string       `json:"UpdatedTime" xml:"UpdatedTime"`
	JobId       int64        `json:"JobId" xml:"JobId"`
	HomeRegion  string       `json:"HomeRegion" xml:"HomeRegion"`
	Status      []StatusItem `json:"Status" xml:"Status"`
}

// CreateGetDeliveryHistoryJobRequest creates a request to invoke GetDeliveryHistoryJob API
func CreateGetDeliveryHistoryJobRequest() (request *GetDeliveryHistoryJobRequest) {
	request = &GetDeliveryHistoryJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Actiontrail", "2020-07-06", "GetDeliveryHistoryJob", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDeliveryHistoryJobResponse creates a response to parse from GetDeliveryHistoryJob response
func CreateGetDeliveryHistoryJobResponse() (response *GetDeliveryHistoryJobResponse) {
	response = &GetDeliveryHistoryJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
