package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MigrateDBCluster invokes the adb.MigrateDBCluster API synchronously
func (client *Client) MigrateDBCluster(request *MigrateDBClusterRequest) (response *MigrateDBClusterResponse, err error) {
	response = CreateMigrateDBClusterResponse()
	err = client.DoAction(request, response)
	return
}

// MigrateDBClusterWithChan invokes the adb.MigrateDBCluster API asynchronously
func (client *Client) MigrateDBClusterWithChan(request *MigrateDBClusterRequest) (<-chan *MigrateDBClusterResponse, <-chan error) {
	responseChan := make(chan *MigrateDBClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MigrateDBCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MigrateDBClusterWithCallback invokes the adb.MigrateDBCluster API asynchronously
func (client *Client) MigrateDBClusterWithCallback(request *MigrateDBClusterRequest, callback func(response *MigrateDBClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MigrateDBClusterResponse
		var err error
		defer close(result)
		response, err = client.MigrateDBCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MigrateDBClusterRequest is the request struct for api MigrateDBCluster
type MigrateDBClusterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// MigrateDBClusterResponse is the response struct for api MigrateDBCluster
type MigrateDBClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMigrateDBClusterRequest creates a request to invoke MigrateDBCluster API
func CreateMigrateDBClusterRequest() (request *MigrateDBClusterRequest) {
	request = &MigrateDBClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "MigrateDBCluster", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMigrateDBClusterResponse creates a response to parse from MigrateDBCluster response
func CreateMigrateDBClusterResponse() (response *MigrateDBClusterResponse) {
	response = &MigrateDBClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
