package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableIsolationRule invokes the ahas_openapi.DisableIsolationRule API synchronously
func (client *Client) DisableIsolationRule(request *DisableIsolationRuleRequest) (response *DisableIsolationRuleResponse, err error) {
	response = CreateDisableIsolationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DisableIsolationRuleWithChan invokes the ahas_openapi.DisableIsolationRule API asynchronously
func (client *Client) DisableIsolationRuleWithChan(request *DisableIsolationRuleRequest) (<-chan *DisableIsolationRuleResponse, <-chan error) {
	responseChan := make(chan *DisableIsolationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableIsolationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableIsolationRuleWithCallback invokes the ahas_openapi.DisableIsolationRule API asynchronously
func (client *Client) DisableIsolationRuleWithCallback(request *DisableIsolationRuleRequest, callback func(response *DisableIsolationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableIsolationRuleResponse
		var err error
		defer close(result)
		response, err = client.DisableIsolationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableIsolationRuleRequest is the request struct for api DisableIsolationRule
type DisableIsolationRuleRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	RuleId       requests.Integer `position:"Query" name:"RuleId"`
}

// DisableIsolationRuleResponse is the response struct for api DisableIsolationRule
type DisableIsolationRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDisableIsolationRuleRequest creates a request to invoke DisableIsolationRule API
func CreateDisableIsolationRuleRequest() (request *DisableIsolationRuleRequest) {
	request = &DisableIsolationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "DisableIsolationRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableIsolationRuleResponse creates a response to parse from DisableIsolationRule response
func CreateDisableIsolationRuleResponse() (response *DisableIsolationRuleResponse) {
	response = &DisableIsolationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
