package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAppInstanceGroup invokes the appstream_center.GetAppInstanceGroup API synchronously
func (client *Client) GetAppInstanceGroup(request *GetAppInstanceGroupRequest) (response *GetAppInstanceGroupResponse, err error) {
	response = CreateGetAppInstanceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetAppInstanceGroupWithChan invokes the appstream_center.GetAppInstanceGroup API asynchronously
func (client *Client) GetAppInstanceGroupWithChan(request *GetAppInstanceGroupRequest) (<-chan *GetAppInstanceGroupResponse, <-chan error) {
	responseChan := make(chan *GetAppInstanceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAppInstanceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAppInstanceGroupWithCallback invokes the appstream_center.GetAppInstanceGroup API asynchronously
func (client *Client) GetAppInstanceGroupWithCallback(request *GetAppInstanceGroupRequest, callback func(response *GetAppInstanceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAppInstanceGroupResponse
		var err error
		defer close(result)
		response, err = client.GetAppInstanceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAppInstanceGroupRequest is the request struct for api GetAppInstanceGroup
type GetAppInstanceGroupRequest struct {
	*requests.RpcRequest
	ProductType        string `position:"Query" name:"ProductType"`
	AppInstanceGroupId string `position:"Query" name:"AppInstanceGroupId"`
}

// GetAppInstanceGroupResponse is the response struct for api GetAppInstanceGroup
type GetAppInstanceGroupResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	TotalCount             int                    `json:"TotalCount" xml:"TotalCount"`
	PageSize               int                    `json:"PageSize" xml:"PageSize"`
	PageNumber             int                    `json:"PageNumber" xml:"PageNumber"`
	AppInstanceGroupModels AppInstanceGroupModels `json:"AppInstanceGroupModels" xml:"AppInstanceGroupModels"`
}

// CreateGetAppInstanceGroupRequest creates a request to invoke GetAppInstanceGroup API
func CreateGetAppInstanceGroupRequest() (request *GetAppInstanceGroupRequest) {
	request = &GetAppInstanceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "GetAppInstanceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAppInstanceGroupResponse creates a response to parse from GetAppInstanceGroup response
func CreateGetAppInstanceGroupResponse() (response *GetAppInstanceGroupResponse) {
	response = &GetAppInstanceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
