package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOtaTask invokes the appstream_center.ListOtaTask API synchronously
func (client *Client) ListOtaTask(request *ListOtaTaskRequest) (response *ListOtaTaskResponse, err error) {
	response = CreateListOtaTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ListOtaTaskWithChan invokes the appstream_center.ListOtaTask API asynchronously
func (client *Client) ListOtaTaskWithChan(request *ListOtaTaskRequest) (<-chan *ListOtaTaskResponse, <-chan error) {
	responseChan := make(chan *ListOtaTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOtaTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOtaTaskWithCallback invokes the appstream_center.ListOtaTask API asynchronously
func (client *Client) ListOtaTaskWithCallback(request *ListOtaTaskRequest, callback func(response *ListOtaTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOtaTaskResponse
		var err error
		defer close(result)
		response, err = client.ListOtaTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOtaTaskRequest is the request struct for api ListOtaTask
type ListOtaTaskRequest struct {
	*requests.RpcRequest
	OtaType            string           `position:"Body" name:"OtaType"`
	PageNumber         requests.Integer `position:"Body" name:"PageNumber"`
	AppInstanceGroupId string           `position:"Body" name:"AppInstanceGroupId"`
	PageSize           requests.Integer `position:"Body" name:"PageSize"`
}

// ListOtaTaskResponse is the response struct for api ListOtaTask
type ListOtaTaskResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	TaskList   []Data `json:"TaskList" xml:"TaskList"`
}

// CreateListOtaTaskRequest creates a request to invoke ListOtaTask API
func CreateListOtaTaskRequest() (request *ListOtaTaskRequest) {
	request = &ListOtaTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "ListOtaTask", "", "")
	request.Method = requests.POST
	return
}

// CreateListOtaTaskResponse creates a response to parse from ListOtaTask response
func CreateListOtaTaskResponse() (response *ListOtaTaskResponse) {
	response = &ListOtaTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
