package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTenantConfig invokes the appstream_center.ListTenantConfig API synchronously
func (client *Client) ListTenantConfig(request *ListTenantConfigRequest) (response *ListTenantConfigResponse, err error) {
	response = CreateListTenantConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ListTenantConfigWithChan invokes the appstream_center.ListTenantConfig API asynchronously
func (client *Client) ListTenantConfigWithChan(request *ListTenantConfigRequest) (<-chan *ListTenantConfigResponse, <-chan error) {
	responseChan := make(chan *ListTenantConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTenantConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTenantConfigWithCallback invokes the appstream_center.ListTenantConfig API asynchronously
func (client *Client) ListTenantConfigWithCallback(request *ListTenantConfigRequest, callback func(response *ListTenantConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTenantConfigResponse
		var err error
		defer close(result)
		response, err = client.ListTenantConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTenantConfigRequest is the request struct for api ListTenantConfig
type ListTenantConfigRequest struct {
	*requests.RpcRequest
}

// ListTenantConfigResponse is the response struct for api ListTenantConfig
type ListTenantConfigResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	TenantConfigModel TenantConfigModel `json:"TenantConfigModel" xml:"TenantConfigModel"`
}

// CreateListTenantConfigRequest creates a request to invoke ListTenantConfig API
func CreateListTenantConfigRequest() (request *ListTenantConfigRequest) {
	request = &ListTenantConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "ListTenantConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateListTenantConfigResponse creates a response to parse from ListTenantConfig response
func CreateListTenantConfigResponse() (response *ListTenantConfigResponse) {
	response = &ListTenantConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
