package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableMetric invokes the arms.EnableMetric API synchronously
func (client *Client) EnableMetric(request *EnableMetricRequest) (response *EnableMetricResponse, err error) {
	response = CreateEnableMetricResponse()
	err = client.DoAction(request, response)
	return
}

// EnableMetricWithChan invokes the arms.EnableMetric API asynchronously
func (client *Client) EnableMetricWithChan(request *EnableMetricRequest) (<-chan *EnableMetricResponse, <-chan error) {
	responseChan := make(chan *EnableMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableMetricWithCallback invokes the arms.EnableMetric API asynchronously
func (client *Client) EnableMetricWithCallback(request *EnableMetricRequest, callback func(response *EnableMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableMetricResponse
		var err error
		defer close(result)
		response, err = client.EnableMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableMetricRequest is the request struct for api EnableMetric
type EnableMetricRequest struct {
	*requests.RpcRequest
	DropMetric string `position:"Query" name:"DropMetric"`
	ClusterId  string `position:"Query" name:"ClusterId"`
}

// EnableMetricResponse is the response struct for api EnableMetric
type EnableMetricResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Code      int64  `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateEnableMetricRequest creates a request to invoke EnableMetric API
func CreateEnableMetricRequest() (request *EnableMetricRequest) {
	request = &EnableMetricRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "EnableMetric", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableMetricResponse creates a response to parse from EnableMetric response
func CreateEnableMetricResponse() (response *EnableMetricResponse) {
	response = &EnableMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
