package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePrometheusIntegration invokes the arms.UpdatePrometheusIntegration API synchronously
func (client *Client) UpdatePrometheusIntegration(request *UpdatePrometheusIntegrationRequest) (response *UpdatePrometheusIntegrationResponse, err error) {
	response = CreateUpdatePrometheusIntegrationResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePrometheusIntegrationWithChan invokes the arms.UpdatePrometheusIntegration API asynchronously
func (client *Client) UpdatePrometheusIntegrationWithChan(request *UpdatePrometheusIntegrationRequest) (<-chan *UpdatePrometheusIntegrationResponse, <-chan error) {
	responseChan := make(chan *UpdatePrometheusIntegrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePrometheusIntegration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePrometheusIntegrationWithCallback invokes the arms.UpdatePrometheusIntegration API asynchronously
func (client *Client) UpdatePrometheusIntegrationWithCallback(request *UpdatePrometheusIntegrationRequest, callback func(response *UpdatePrometheusIntegrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePrometheusIntegrationResponse
		var err error
		defer close(result)
		response, err = client.UpdatePrometheusIntegration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePrometheusIntegrationRequest is the request struct for api UpdatePrometheusIntegration
type UpdatePrometheusIntegrationRequest struct {
	*requests.RpcRequest
	IntegrationType string           `position:"Query" name:"IntegrationType"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	InstanceId      requests.Integer `position:"Query" name:"InstanceId"`
	Param           string           `position:"Query" name:"Param"`
}

// UpdatePrometheusIntegrationResponse is the response struct for api UpdatePrometheusIntegration
type UpdatePrometheusIntegrationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdatePrometheusIntegrationRequest creates a request to invoke UpdatePrometheusIntegration API
func CreateUpdatePrometheusIntegrationRequest() (request *UpdatePrometheusIntegrationRequest) {
	request = &UpdatePrometheusIntegrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "UpdatePrometheusIntegration", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdatePrometheusIntegrationResponse creates a response to parse from UpdatePrometheusIntegration response
func CreateUpdatePrometheusIntegrationResponse() (response *UpdatePrometheusIntegrationResponse) {
	response = &UpdatePrometheusIntegrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
