package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAccessorDomain invokes the beian.QueryAccessorDomain API synchronously
func (client *Client) QueryAccessorDomain(request *QueryAccessorDomainRequest) (response *QueryAccessorDomainResponse, err error) {
	response = CreateQueryAccessorDomainResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAccessorDomainWithChan invokes the beian.QueryAccessorDomain API asynchronously
func (client *Client) QueryAccessorDomainWithChan(request *QueryAccessorDomainRequest) (<-chan *QueryAccessorDomainResponse, <-chan error) {
	responseChan := make(chan *QueryAccessorDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAccessorDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAccessorDomainWithCallback invokes the beian.QueryAccessorDomain API asynchronously
func (client *Client) QueryAccessorDomainWithCallback(request *QueryAccessorDomainRequest, callback func(response *QueryAccessorDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAccessorDomainResponse
		var err error
		defer close(result)
		response, err = client.QueryAccessorDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAccessorDomainRequest is the request struct for api QueryAccessorDomain
type QueryAccessorDomainRequest struct {
	*requests.RpcRequest
	Caller string `position:"Query" name:"Caller"`
	Domain string `position:"Query" name:"Domain"`
}

// QueryAccessorDomainResponse is the response struct for api QueryAccessorDomain
type QueryAccessorDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateQueryAccessorDomainRequest creates a request to invoke QueryAccessorDomain API
func CreateQueryAccessorDomainRequest() (request *QueryAccessorDomainRequest) {
	request = &QueryAccessorDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "QueryAccessorDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryAccessorDomainResponse creates a response to parse from QueryAccessorDomain response
func CreateQueryAccessorDomainResponse() (response *QueryAccessorDomainResponse) {
	response = &QueryAccessorDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
