package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIpPolicy invokes the biz_ipdb.DeleteIpPolicy API synchronously
func (client *Client) DeleteIpPolicy(request *DeleteIpPolicyRequest) (response *DeleteIpPolicyResponse, err error) {
	response = CreateDeleteIpPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIpPolicyWithChan invokes the biz_ipdb.DeleteIpPolicy API asynchronously
func (client *Client) DeleteIpPolicyWithChan(request *DeleteIpPolicyRequest) (<-chan *DeleteIpPolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteIpPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIpPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIpPolicyWithCallback invokes the biz_ipdb.DeleteIpPolicy API asynchronously
func (client *Client) DeleteIpPolicyWithCallback(request *DeleteIpPolicyRequest, callback func(response *DeleteIpPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIpPolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteIpPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIpPolicyRequest is the request struct for api DeleteIpPolicy
type DeleteIpPolicyRequest struct {
	*requests.RpcRequest
	PolicyId requests.Integer `position:"Query" name:"PolicyId"`
}

// DeleteIpPolicyResponse is the response struct for api DeleteIpPolicy
type DeleteIpPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteIpPolicyRequest creates a request to invoke DeleteIpPolicy API
func CreateDeleteIpPolicyRequest() (request *DeleteIpPolicyRequest) {
	request = &DeleteIpPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "DeleteIpPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteIpPolicyResponse creates a response to parse from DeleteIpPolicy response
func CreateDeleteIpPolicyResponse() (response *DeleteIpPolicyResponse) {
	response = &DeleteIpPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
