package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLocationTree invokes the biz_ipdb.ListLocationTree API synchronously
func (client *Client) ListLocationTree(request *ListLocationTreeRequest) (response *ListLocationTreeResponse, err error) {
	response = CreateListLocationTreeResponse()
	err = client.DoAction(request, response)
	return
}

// ListLocationTreeWithChan invokes the biz_ipdb.ListLocationTree API asynchronously
func (client *Client) ListLocationTreeWithChan(request *ListLocationTreeRequest) (<-chan *ListLocationTreeResponse, <-chan error) {
	responseChan := make(chan *ListLocationTreeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLocationTree(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLocationTreeWithCallback invokes the biz_ipdb.ListLocationTree API asynchronously
func (client *Client) ListLocationTreeWithCallback(request *ListLocationTreeRequest, callback func(response *ListLocationTreeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLocationTreeResponse
		var err error
		defer close(result)
		response, err = client.ListLocationTree(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLocationTreeRequest is the request struct for api ListLocationTree
type ListLocationTreeRequest struct {
	*requests.RpcRequest
	BizLine string `position:"Query" name:"BizLine"`
}

// ListLocationTreeResponse is the response struct for api ListLocationTree
type ListLocationTreeResponse struct {
	*responses.BaseResponse
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	Locations  Locations `json:"Locations" xml:"Locations"`
}

// CreateListLocationTreeRequest creates a request to invoke ListLocationTree API
func CreateListLocationTreeRequest() (request *ListLocationTreeRequest) {
	request = &ListLocationTreeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "ListLocationTree", "", "")
	request.Method = requests.POST
	return
}

// CreateListLocationTreeResponse creates a response to parse from ListLocationTree response
func CreateListLocationTreeResponse() (response *ListLocationTreeResponse) {
	response = &ListLocationTreeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
