package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSavingsPlansUsageTotal invokes the bssopenapi.DescribeSavingsPlansUsageTotal API synchronously
func (client *Client) DescribeSavingsPlansUsageTotal(request *DescribeSavingsPlansUsageTotalRequest) (response *DescribeSavingsPlansUsageTotalResponse, err error) {
	response = CreateDescribeSavingsPlansUsageTotalResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSavingsPlansUsageTotalWithChan invokes the bssopenapi.DescribeSavingsPlansUsageTotal API asynchronously
func (client *Client) DescribeSavingsPlansUsageTotalWithChan(request *DescribeSavingsPlansUsageTotalRequest) (<-chan *DescribeSavingsPlansUsageTotalResponse, <-chan error) {
	responseChan := make(chan *DescribeSavingsPlansUsageTotalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSavingsPlansUsageTotal(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSavingsPlansUsageTotalWithCallback invokes the bssopenapi.DescribeSavingsPlansUsageTotal API asynchronously
func (client *Client) DescribeSavingsPlansUsageTotalWithCallback(request *DescribeSavingsPlansUsageTotalRequest, callback func(response *DescribeSavingsPlansUsageTotalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSavingsPlansUsageTotalResponse
		var err error
		defer close(result)
		response, err = client.DescribeSavingsPlansUsageTotal(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSavingsPlansUsageTotalRequest is the request struct for api DescribeSavingsPlansUsageTotal
type DescribeSavingsPlansUsageTotalRequest struct {
	*requests.RpcRequest
	PeriodType  string           `position:"Query" name:"PeriodType"`
	BillOwnerId requests.Integer `position:"Query" name:"BillOwnerId"`
	StartPeriod string           `position:"Query" name:"StartPeriod"`
	EndPeriod   string           `position:"Query" name:"EndPeriod"`
}

// DescribeSavingsPlansUsageTotalResponse is the response struct for api DescribeSavingsPlansUsageTotal
type DescribeSavingsPlansUsageTotalResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeSavingsPlansUsageTotalRequest creates a request to invoke DescribeSavingsPlansUsageTotal API
func CreateDescribeSavingsPlansUsageTotalRequest() (request *DescribeSavingsPlansUsageTotalRequest) {
	request = &DescribeSavingsPlansUsageTotalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "DescribeSavingsPlansUsageTotal", "bssopenapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSavingsPlansUsageTotalResponse creates a response to parse from DescribeSavingsPlansUsageTotal response
func CreateDescribeSavingsPlansUsageTotalResponse() (response *DescribeSavingsPlansUsageTotalResponse) {
	response = &DescribeSavingsPlansUsageTotalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
