package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCommodityList invokes the bssopenapi.QueryCommodityList API synchronously
func (client *Client) QueryCommodityList(request *QueryCommodityListRequest) (response *QueryCommodityListResponse, err error) {
	response = CreateQueryCommodityListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCommodityListWithChan invokes the bssopenapi.QueryCommodityList API asynchronously
func (client *Client) QueryCommodityListWithChan(request *QueryCommodityListRequest) (<-chan *QueryCommodityListResponse, <-chan error) {
	responseChan := make(chan *QueryCommodityListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCommodityList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCommodityListWithCallback invokes the bssopenapi.QueryCommodityList API asynchronously
func (client *Client) QueryCommodityListWithCallback(request *QueryCommodityListRequest, callback func(response *QueryCommodityListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCommodityListResponse
		var err error
		defer close(result)
		response, err = client.QueryCommodityList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCommodityListRequest is the request struct for api QueryCommodityList
type QueryCommodityListRequest struct {
	*requests.RpcRequest
	ProductCode string `position:"Query" name:"ProductCode"`
}

// QueryCommodityListResponse is the response struct for api QueryCommodityList
type QueryCommodityListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryCommodityListRequest creates a request to invoke QueryCommodityList API
func CreateQueryCommodityListRequest() (request *QueryCommodityListRequest) {
	request = &QueryCommodityListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QueryCommodityList", "bssopenapi", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQueryCommodityListResponse creates a response to parse from QueryCommodityList response
func CreateQueryCommodityListResponse() (response *QueryCommodityListResponse) {
	response = &QueryCommodityListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
