package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetResellerUserStatus invokes the bssopenapi.SetResellerUserStatus API synchronously
func (client *Client) SetResellerUserStatus(request *SetResellerUserStatusRequest) (response *SetResellerUserStatusResponse, err error) {
	response = CreateSetResellerUserStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SetResellerUserStatusWithChan invokes the bssopenapi.SetResellerUserStatus API asynchronously
func (client *Client) SetResellerUserStatusWithChan(request *SetResellerUserStatusRequest) (<-chan *SetResellerUserStatusResponse, <-chan error) {
	responseChan := make(chan *SetResellerUserStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetResellerUserStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetResellerUserStatusWithCallback invokes the bssopenapi.SetResellerUserStatus API asynchronously
func (client *Client) SetResellerUserStatusWithCallback(request *SetResellerUserStatusRequest, callback func(response *SetResellerUserStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetResellerUserStatusResponse
		var err error
		defer close(result)
		response, err = client.SetResellerUserStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetResellerUserStatusRequest is the request struct for api SetResellerUserStatus
type SetResellerUserStatusRequest struct {
	*requests.RpcRequest
	StopMode     string `position:"Query" name:"StopMode"`
	OwnerId      string `position:"Query" name:"OwnerId"`
	BusinessType string `position:"Query" name:"BusinessType"`
	Status       string `position:"Query" name:"Status"`
}

// SetResellerUserStatusResponse is the response struct for api SetResellerUserStatus
type SetResellerUserStatusResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSetResellerUserStatusRequest creates a request to invoke SetResellerUserStatus API
func CreateSetResellerUserStatusRequest() (request *SetResellerUserStatusRequest) {
	request = &SetResellerUserStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "SetResellerUserStatus", "bssopenapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetResellerUserStatusResponse creates a response to parse from SetResellerUserStatus response
func CreateSetResellerUserStatusResponse() (response *SetResellerUserStatusResponse) {
	response = &SetResellerUserStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
